! Declarations specifiques au cas Toga
        character*80 :: fich_toga
!        integer nlev_prof
!        parameter (nlev_prof = 41)
        integer nlev_toga, nt_toga
        parameter (nlev_toga=41, nt_toga=480)
        integer year_ini_toga, day_ini_toga, mth_ini_toga
        real day_ju_ini_toga   ! Julian day of toga coare first day
        parameter (year_ini_toga=1992) 
        parameter (mth_ini_toga=11)
        parameter (day_ini_toga=1)  !  1erNov1992
        real dt_toga
        parameter (dt_toga=6.*3600.)
!!
        integer year_print, month_print, day_print
        real    sec_print
!!
        real ts_toga(nt_toga)
        real plev_toga(nlev_toga,nt_toga),w_toga(nlev_toga,nt_toga)
        real t_toga(nlev_toga,nt_toga),q_toga(nlev_toga,nt_toga)
        real u_toga(nlev_toga,nt_toga),v_toga(nlev_toga,nt_toga)
        real ht_toga(nlev_toga,nt_toga),vt_toga(nlev_toga,nt_toga)
        real hq_toga(nlev_toga,nt_toga),vq_toga(nlev_toga,nt_toga)

        real ts_prof
        real plev_prof(nlev_toga),w_prof(nlev_toga)
        real t_prof(nlev_toga),q_prof(nlev_toga)
        real u_prof(nlev_toga),v_prof(nlev_toga)
        real ht_prof(nlev_toga),vt_prof(nlev_toga)
        real hq_prof(nlev_toga),vq_prof(nlev_toga)

        real w_mod(llm), t_mod(llm),q_mod(llm)
        real u_mod(llm),v_mod(llm), ht_mod(llm),vt_mod(llm)
        real hq_mod(llm),vq_mod(llm),qv_mod(llm),ql_mod(llm),qt_mod(llm)

        real ts_cur
        common /sst_forcing/ts_cur ! also in read_tsurf1d.F
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Declarations specifiques au cas RICO
        character*80 :: fich_rico
        integer nlev_rico

        parameter (nlev_rico=81)
        real ts_rico,ps_rico
        real w_rico(llm)
        real t_rico(llm),q_rico(llm)
        real u_rico(llm),v_rico(llm)
        real dth_rico(llm)
        real dqh_rico(llm)
        real du_age(llm),dv_age(llm)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Declarations specifiques au cas TWPice
        character*80 :: fich_twpice
        integer nlev_twpi, nt_twpi
        parameter (nlev_twpi=40, nt_twpi=215)
        integer year_ini_twpi, day_ini_twpi, mth_ini_twpi
        real heure_ini_twpi
        real day_ju_ini_twpi   ! Julian day of twpice first day
        parameter (year_ini_twpi=2006) 
        parameter (mth_ini_twpi=1)
        parameter (day_ini_twpi=17)  ! 17 = 17Jan2006
        parameter (heure_ini_twpi=10800.) !3h en secondes
        real dt_twpi
        parameter (dt_twpi=3.*3600.)

        real ts_twpi(nt_twpi)
        real plev_twpi(nlev_twpi,nt_twpi),w_twpi(nlev_twpi,nt_twpi)
        real t_twpi(nlev_twpi,nt_twpi),q_twpi(nlev_twpi,nt_twpi)
        real u_twpi(nlev_twpi,nt_twpi),v_twpi(nlev_twpi,nt_twpi)
        real ht_twpi(nlev_twpi,nt_twpi),vt_twpi(nlev_twpi,nt_twpi)
        real hq_twpi(nlev_twpi,nt_twpi),vq_twpi(nlev_twpi,nt_twpi)

        real ts_proftwp
        real plev_proftwp(nlev_twpi),w_proftwp(nlev_twpi)
        real t_proftwp(nlev_twpi),q_proftwp(nlev_twpi)
        real u_proftwp(nlev_twpi),v_proftwp(nlev_twpi)
        real ht_proftwp(nlev_twpi),vt_proftwp(nlev_twpi)
        real hq_proftwp(nlev_twpi),vq_proftwp(nlev_twpi)


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!Declarations specifiques au cas AMMA
        character*80 :: fich_amma
! Option du cas AMMA ou on impose la discretisation verticale (Ap,Bp)
        integer nlev_amma, nt_amma
!       parameter (nlev_amma=29, nt_amma=48)  ! Fleur, juillet 2012
        parameter (nlev_amma=36, nt_amma=48)  ! Romain, octobre 2012
!       parameter (nlev_amma=26, nt_amma=48)  ! Test MPL feverier 2013
        integer year_ini_amma, day_ini_amma, mth_ini_amma
        real heure_ini_amma
        real day_ju_ini_amma   ! Julian day of amma first day
        parameter (year_ini_amma=2006) 
        parameter (mth_ini_amma=7)
        parameter (day_ini_amma=10)  ! 10 = 10Juil2006
        parameter (heure_ini_amma=0.) !0h en secondes
        real dt_amma
        parameter (dt_amma=1800.)

!profils initiaux:
        real plev_amma(nlev_amma)
        
        real z_amma(nlev_amma)
        real th_amma(nlev_amma),q_amma(nlev_amma)
        real u_amma(nlev_amma)
        real v_amma(nlev_amma)

        real th_ammai(nlev_amma),q_ammai(nlev_amma)
        real u_ammai(nlev_amma)
        real v_ammai(nlev_amma)
        real vitw_ammai(nlev_amma) 
        real ht_ammai(nlev_amma)
        real hq_ammai(nlev_amma)
        real vt_ammai(nlev_amma)
        real vq_ammai(nlev_amma)
        
!forcings
        real ht_amma(nlev_amma,nt_amma)
        real hq_amma(nlev_amma,nt_amma)
        real vitw_amma(nlev_amma,nt_amma)
        real lat_amma(nt_amma),sens_amma(nt_amma)

!champs interpoles
        real vitw_profamma(nlev_amma)
        real ht_profamma(nlev_amma)
        real hq_profamma(nlev_amma)
        real lat_profamma,sens_profamma
        real vt_profamma(nlev_amma)
        real vq_profamma(nlev_amma)
        real th_profamma(nlev_amma)
        real q_profamma(nlev_amma)
        real u_profamma(nlev_amma)
        real v_profamma(nlev_amma)

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!Declarations specifiques au cas FIRE
        character*80 :: fich_fire
        integer nlev_fire, nt_fire
        parameter (nlev_fire=120, nt_fire=1)  
        integer year_ini_fire, day_ini_fire, mth_ini_fire
        real heure_ini_fire
        parameter (year_ini_fire=1987) 
        parameter (mth_ini_fire=7)
        parameter (day_ini_fire=14)  ! 14 = 14Juil1987
        parameter (heure_ini_fire=0.) !0h en secondes

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Declarations specifiques au cas GCSSold
        character*80 :: fich_gcssold_ctl
        character*80 :: fich_gcssold_dat
        real  ht_gcssold(llm),hq_gcssold(llm),hw_gcssold(llm)
        real  hu_gcssold(llm)
        real  hv_gcssold(llm)
        real  hthturb_gcssold(llm)
        real  hqturb_gcssold(llm)
        real  Ts_gcssold
        real  dtime_frcg
        logical :: Turb_fcg_gcssold

        common /turb_forcing/
     s  dtime_frcg,hthturb_gcssold, hqturb_gcssold,Turb_fcg_gcssold
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Declarations specifiques au cas Arm_cu
        character*80 :: fich_armcu


        integer nlev_armcu, nt_armcu
        parameter (nlev_armcu=40, nt_armcu=31)
        integer year_ini_armcu, day_ini_armcu, mth_ini_armcu
        real  heure_ini_armcu
        real day_ju_ini_armcu                                ! Julian day of armcu case first day
        parameter (year_ini_armcu=1997) 
        parameter (mth_ini_armcu=6)
        parameter (day_ini_armcu=21)  ! 172 = 21 juin 1997
        parameter (heure_ini_armcu=41400)   ! 11:30 en secondes
        real dt_armcu
        parameter (dt_armcu=1.*1800.)   ! forcages donnes ttes les demi-heures par ifa_armcu.txt
        real sens_armcu(nt_armcu),flat_armcu(nt_armcu)
        real adv_theta_armcu(nt_armcu),rad_theta_armcu(nt_armcu)
        real adv_qt_armcu(nt_armcu)
        real theta_mod(llm),rv_mod(llm),play_mod(llm)
! profc comme "profil armcu"
        
! forcages interpoles dans le temps
        real adv_theta_prof,rad_theta_prof,adv_qt_prof
        real sens_prof,flat_prof,fact
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! declarations specifiques au cas Sandu
        character*80 :: fich_sandu
!        integer nlev_prof
!        parameter (nlev_prof = 41)
        integer nlev_sandu, nt_sandu
        parameter (nlev_sandu=87, nt_sandu=13)
        integer year_ini_sandu, day_ini_sandu, mth_ini_sandu
        real day_ju_ini_sandu                                ! Julian day of sandu case first day
        parameter (year_ini_sandu=2006)
        parameter (mth_ini_sandu=7)
        parameter (day_ini_sandu=15)  ! 196 = 15 juillet 2006
        real dt_sandu
        logical  :: trouve_700=.true.
        parameter (dt_sandu=6.*3600.)   ! forcages donnes ttes les 6 heures par ifa_sandu.txt
!       parameter (tau_sandu=3600.)  ! temps de relaxation u,v,thetal,qt vers profil init et au dessus 700hPa
!!
        real ts_sandu(nt_sandu)
! profs comme "profil sandu"
        real plev_profs(nlev_sandu)
        real t_profs(nlev_sandu),thl_profs(nlev_sandu)
        real q_profs(nlev_sandu)
        real u_profs(nlev_sandu),v_profs(nlev_sandu),w_profs(nlev_sandu)
        real omega_profs(nlev_sandu),o3mmr_profs(nlev_sandu)

        real thl_mod(llm),omega_mod(llm),o3mmr_mod(llm),tke_mod(llm)
!vertical advection computation
        real d_t_z(llm), d_q_z(llm)
        real d_t_dyn_z(llm), d_q_dyn_z(llm)
        real zz(llm)
        real zfact
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Declarations specifiques au cas Astex
        character*80 :: fich_astex
        integer nlev_astex, nt_astex
        parameter (nlev_astex=34, nt_astex=49)
        integer year_ini_astex, day_ini_astex, mth_ini_astex
        real day_ju_ini_astex                                ! Julian day of astex case first day
        parameter (year_ini_astex=1992)
        parameter (mth_ini_astex=6)
        parameter (day_ini_astex=13)  ! 165 = 13 juin 1992
        real dt_astex
        parameter (dt_astex=3600.)    ! forcages donnes ttes les heures par ifa_astex.txt
        real ts_astex(nt_astex),div_astex(nt_astex),ug_astex(nt_astex)
        real vg_astex(nt_astex),ufa_astex(nt_astex),vfa_astex(nt_astex)
        real div_prof,ug_prof,vg_prof,ufa_prof,vfa_prof
! profa comme "profil astex"
        real plev_profa(nlev_astex)
        real t_profa(nlev_astex),thl_profa(nlev_astex)
        real qv_profa(nlev_astex),ql_profa(nlev_astex)
        real qt_profa(nlev_astex),o3mmr_profa(nlev_astex)
        real u_profa(nlev_astex),v_profa(nlev_astex),w_profa(nlev_astex)
        real tke_profa(nlev_astex)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

