!
! $Header$
!
MODULE phys_output_write_mod

! Author: Abderrahmane IDELKADI (original include file)
! Author: Laurent FAIRHEAD (transformation to module/subroutine)
! Author: Ulysse GERARD (effective implementation)


   CONTAINS 
     
! ug Routine pour définir (los du premier passageà) ET sortir les variables
    SUBROUTINE phys_output_write(itap, pdtphys, paprs, pphis, &
   &                  pplay, lmax_th, aerosol_couple,         &
   &                  ok_ade, ok_aie, ivap, new_aod, ok_sync, &
   &                  ptconv, read_climoz, clevSTD, ptconvth, &
   &                  d_t, qx, d_qx, zmasse, flag_aerosol_strat)

! This subroutine does the actual writing of diagnostics that were
! defined and initialised in phys_output_mod.F90

    USE dimphy
    USE control_mod
    USE phys_output_ctrlout_mod 
    USE phys_state_var_mod
    USE phys_local_var_mod
    USE indice_sol_mod
    USE infotrac
    USE comgeomphy
    USE surface_data,     ONLY : type_ocean, ok_veget
    USE aero_mod
    USE ioipsl
    USE write_field_phy
    USE iophy

    IMPLICIT NONE

    INCLUDE "temps.h"
    INCLUDE "clesphys.h"
    INCLUDE "thermcell.h"
    INCLUDE "compbl.h"
    INCLUDE "YOMCST.h"
    INCLUDE "dimensions.h"

! Input
    INTEGER :: itap, ivap, read_climoz
    INTEGER, DIMENSION(klon) :: lmax_th
    LOGICAL :: aerosol_couple, ok_sync
    LOGICAL :: ok_ade, ok_aie, new_aod
    LOGICAL, DIMENSION(klon, klev) :: ptconv, ptconvth
    REAL :: pdtphys
    CHARACTER (LEN=4), DIMENSION(nlevSTD) :: clevSTD
    REAL, DIMENSION(klon) :: pphis
    REAL, DIMENSION(klon, klev) :: pplay, d_t
    REAL, DIMENSION(klon, klev+1) :: paprs
    REAL, DIMENSION(klon,klev,nqtot) :: qx, d_qx
    REAL, DIMENSION(klon, llm) :: zmasse
    LOGICAL :: flag_aerosol_strat

! Local
    INTEGER, PARAMETER :: jjmp1=jjm+1-1/jjm
    INTEGER :: itau_w
    INTEGER :: i, iff, iq, nsrf, k, ll, naero
    REAL, DIMENSION (klon) :: zx_tmp_fi2d
    REAL, DIMENSION (klon,klev) :: zx_tmp_fi3d, zpt_conv
    REAL, DIMENSION (klon,klev+1) :: zx_tmp_fi3d1
    CHARACTER (LEN=4)              :: bb2
    INTEGER, DIMENSION(iim*jjmp1)  :: ndex2d
    INTEGER, DIMENSION(iim*jjmp1*klev) :: ndex3d
    REAL, PARAMETER :: dobson_u = 2.1415e-05 ! Dobson unit, in kg m-2

    IF(vars_defined) THEN
! On calcul le nouveau tau:
     itau_w = itau_phy + itap + start_time * day_step / iphysiq
! On le donne à iophy pour que les histwrite y aient accès:
     CALL set_itau_iophy(itau_w)
    ENDIF

! On procède à l'écriture ou à la définition des nombreuses variables:
#include "phys_output_write_F90.h"

    IF(vars_defined) THEN
! On synchronise les fichiers pour IOIPSL
      DO iff=1,nfiles
          IF (ok_sync .AND. clef_files(iff)) THEN
!$OMP MASTER
              CALL histsync(nid_files(iff))
!$OMP END MASTER
          ENDIF
      END DO

    ELSE
    vars_defined = .TRUE.
    ENDIF

      


    END SUBROUTINE phys_output_write



  END MODULE phys_output_write_mod

