! $Id: phys_output_mod.F90 1791 2013-07-17 10:20:19Z emillour $
!
! Abderrahmane 12 2007
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!! Ecreture des Sorties du modele dans les fichiers Netcdf :
! histmth.nc : moyennes mensuelles
! histday.nc : moyennes journalieres
! histhf.nc  : moyennes toutes les 3 heures
! histins.nc : valeurs instantanees
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

MODULE phys_output_mod 
  USE indice_sol_mod
  USE phys_output_var_mod
  USE phys_output_ctrlout_mod
  USE aero_mod, only : naero_spc,name_aero

  IMPLICIT NONE

  PRIVATE histdef2d, histdef3d, conf_physoutputs

  REAL, PRIVATE, SAVE                :: zdtime
  !$OMP THREADPRIVATE(zdtime)



CONTAINS

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!! Ouverture des fichier et definition des variable de sortie !!!!!!!!
  !! histbeg, histvert et histdef
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 

  SUBROUTINE phys_output_open(rlon,rlat,pim,tabij,ipt,jpt,plon,plat, &
       jjmp1,nlevSTD,clevSTD,nbteta, &
       ctetaSTD, dtime, ok_veget, &
       type_ocean, iflag_pbl,ok_mensuel,ok_journe, &
       ok_hf,ok_instan,ok_LES,ok_ade,ok_aie, read_climoz, &
       phys_out_filestations, &
       new_aod, aerosol_couple, flag_aerosol_strat)   

    USE iophy 
    USE dimphy
    USE infotrac
    USE ioipsl
    USE phys_cal_mod, only : hour
    USE mod_phys_lmdz_para
    USE aero_mod, only : naero_spc,name_aero

    IMPLICIT NONE
    include "dimensions.h"
    include "temps.h"
    include "clesphys.h"
    include "thermcell.h"
    include "comvert.h"
    include "iniprint.h"

    real,dimension(klon),intent(in) :: rlon
    real,dimension(klon),intent(in) :: rlat
    INTEGER, intent(in)             :: pim
    INTEGER, DIMENSION(pim)            :: tabij
    INTEGER,dimension(pim), intent(in) :: ipt, jpt
    REAL,dimension(pim), intent(in) :: plat, plon
    REAL,dimension(pim,2) :: plat_bounds, plon_bounds

    INTEGER                               :: jjmp1
    INTEGER                               :: nbteta, nlevSTD, radpas
    LOGICAL                               :: ok_mensuel, ok_journe, ok_hf, ok_instan
    LOGICAL                               :: ok_LES,ok_ade,ok_aie,flag_aerosol_strat
    LOGICAL                               :: new_aod, aerosol_couple
    INTEGER, intent(in)::  read_climoz ! read ozone climatology
    !     Allowed values are 0, 1 and 2
    !     0: do not read an ozone climatology
    !     1: read a single ozone climatology that will be used day and night
    !     2: read two ozone climatologies, the average day and night
    !     climatology and the daylight climatology

    REAL                                  :: dtime
    INTEGER                               :: idayref
    REAL                                  :: zjulian
    REAL, DIMENSION(klev)                 :: Ahyb, Bhyb, Alt
    CHARACTER(LEN=4), DIMENSION(nlevSTD)  :: clevSTD
    INTEGER                               :: nsrf, k, iq, iiq, iff, i, j, ilev
    INTEGER                               :: naero
    LOGICAL                               :: ok_veget
    INTEGER                               :: iflag_pbl
    CHARACTER(LEN=4)                      :: bb2
    CHARACTER(LEN=2)                      :: bb3
    CHARACTER(LEN=6)                      :: type_ocean
    CHARACTER(LEN=3)                      :: ctetaSTD(nbteta)
    REAL, DIMENSION(nfiles)               :: ecrit_files
    CHARACTER(LEN=20), DIMENSION(nfiles)  :: phys_out_filenames
    INTEGER, DIMENSION(iim*jjmp1)         ::  ndex2d
    INTEGER, DIMENSION(iim*jjmp1*klev)    :: ndex3d
    INTEGER                               :: imin_ins, imax_ins
    INTEGER                               :: jmin_ins, jmax_ins
    INTEGER, DIMENSION(nfiles)            :: phys_out_levmin, phys_out_levmax
    INTEGER, DIMENSION(nfiles)            :: phys_out_filelevels
    CHARACTER(LEN=20), DIMENSION(nfiles)  :: chtimestep   = (/ 'DefFreq', 'DefFreq','DefFreq', 'DefFreq', 'DefFreq', 'DefFreq' /)
    LOGICAL, DIMENSION(nfiles)            :: phys_out_filekeys
    LOGICAL, DIMENSION(nfiles)            :: phys_out_filestations

!!!!!!!!!! stockage dans une region limitee pour chaque fichier !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    !                 entre [phys_out_lonmin,phys_out_lonmax] et [phys_out_latmin,phys_out_latmax]

    LOGICAL, DIMENSION(nfiles), SAVE  :: phys_out_regfkey       = (/ .FALSE., .FALSE., .FALSE.,  .FALSE., .FALSE., .FALSE. /)
    REAL, DIMENSION(nfiles), SAVE     :: phys_out_lonmin        = (/   -180.,   -180.,   -180.,    -180.,   -180.,   -180. /)
    REAL, DIMENSION(nfiles), SAVE     :: phys_out_lonmax        = (/    180.,    180.,    180.,     180.,    180.,    180. /)
    REAL, DIMENSION(nfiles), SAVE     :: phys_out_latmin        = (/    -90.,    -90.,    -90.,     -90.,    -90.,    -90. /)
    REAL, DIMENSION(nfiles), SAVE     :: phys_out_latmax        = (/     90.,     90.,     90.,     90.,     90.,     90. /)

    WRITE(lunout,*) 'Debut phys_output_mod.F90'
    ! Initialisations (Valeurs par defaut

    IF (.NOT. ALLOCATED(o_trac)) ALLOCATE(o_trac(nqtot))
    IF (.NOT. ALLOCATED(o_trac_cum)) ALLOCATE(o_trac_cum(nqtot))

    levmax = (/ klev, klev, klev, klev, klev, klev /)

    phys_out_filenames(1) = 'histmth'
    phys_out_filenames(2) = 'histday'
    phys_out_filenames(3) = 'histhf'
    phys_out_filenames(4) = 'histins'
    phys_out_filenames(5) = 'histLES'
    phys_out_filenames(6) = 'histstn'

    type_ecri(1) = 'ave(X)'
    type_ecri(2) = 'ave(X)'
    type_ecri(3) = 'ave(X)'
    type_ecri(4) = 'inst(X)'
    type_ecri(5) = 'ave(X)'
    type_ecri(6) = 'inst(X)'

    clef_files(1) = ok_mensuel
    clef_files(2) = ok_journe
    clef_files(3) = ok_hf
    clef_files(4) = ok_instan
    clef_files(5) = ok_LES
    clef_files(6) = ok_instan

    !sortir des fichiers "stations" si clef_stations(:)=.TRUE.
    clef_stations(1) = .FALSE.
    clef_stations(2) = .FALSE.
    clef_stations(3) = .FALSE.
    clef_stations(4) = .FALSE.
    clef_stations(5) = .FALSE.
    clef_stations(6) = .FALSE.

    lev_files(1) = lev_histmth
    lev_files(2) = lev_histday
    lev_files(3) = lev_histhf
    lev_files(4) = lev_histins
    lev_files(5) = lev_histLES
    lev_files(6) = lev_histins

    ecrit_files(1) = ecrit_mth
    ecrit_files(2) = ecrit_day
    ecrit_files(3) = ecrit_hf
    ecrit_files(4) = ecrit_ins
    ecrit_files(5) = ecrit_LES
    ecrit_files(6) = ecrit_ins

    !! Lectures des parametres de sorties dans physiq.def

    CALL getin('phys_out_regfkey',phys_out_regfkey)
    CALL getin('phys_out_lonmin',phys_out_lonmin)
    CALL getin('phys_out_lonmax',phys_out_lonmax)
    CALL getin('phys_out_latmin',phys_out_latmin)
    CALL getin('phys_out_latmax',phys_out_latmax)
    phys_out_levmin(:)=levmin(:)
    CALL getin('phys_out_levmin',levmin)
    phys_out_levmax(:)=levmax(:)
    CALL getin('phys_out_levmax',levmax)
    CALL getin('phys_out_filenames',phys_out_filenames)
    phys_out_filekeys(:)=clef_files(:)
    CALL getin('phys_out_filekeys',clef_files)
    phys_out_filestations(:)=clef_stations(:)
    CALL getin('phys_out_filestations',clef_stations)
    phys_out_filelevels(:)=lev_files(:)
    CALL getin('phys_out_filelevels',lev_files)
    CALL getin('phys_out_filetimesteps',chtimestep)
    phys_out_filetypes(:)=type_ecri(:)
    CALL getin('phys_out_filetypes',type_ecri)

    type_ecri_files(:)=type_ecri(:)

    WRITE(lunout,*)'phys_out_lonmin=',phys_out_lonmin
    WRITE(lunout,*)'phys_out_lonmax=',phys_out_lonmax
    WRITE(lunout,*)'phys_out_latmin=',phys_out_latmin
    WRITE(lunout,*)'phys_out_latmax=',phys_out_latmax
    WRITE(lunout,*)'phys_out_filenames=',phys_out_filenames
    WRITE(lunout,*)'phys_out_filetypes=',type_ecri
    WRITE(lunout,*)'phys_out_filekeys=',clef_files
    WRITE(lunout,*)'phys_out_filestations=',clef_stations
    WRITE(lunout,*)'phys_out_filelevels=',lev_files

!!!!!!!!!!!!!!!!!!!!!!! Boucle sur les fichiers !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    ! Appel de histbeg et histvert pour creer le fichier et les niveaux verticaux !!
    ! Appel des histbeg pour definir les variables (nom, moy ou inst, freq de sortie ..
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

    zdtime = dtime         ! Frequence ou l on moyenne

    ! Calcul des Ahyb, Bhyb et Alt
    DO k=1,klev
       Ahyb(k)=(ap(k)+ap(k+1))/2.
       Bhyb(k)=(bp(k)+bp(k+1))/2.
       Alt(k)=log(preff/presnivs(k))*8.
    ENDDO
    !          if(prt_level.ge.1) then
    WRITE(lunout,*)'Ap Hybrid = ',Ahyb(1:klev)
    WRITE(lunout,*)'Bp Hybrid = ',Bhyb(1:klev)
    WRITE(lunout,*)'Alt approx des couches pour une haut d echelle de 8km = ',Alt(1:klev)
    !          endif
    DO iff=1,nfiles

       ! Calculate ecrit_files for all files
       IF ( chtimestep(iff).eq.'DefFreq' ) then
          ! Par defaut ecrit_files = (ecrit_mensuel ecrit_jour ecrit_hf ...)*86400.
          ecrit_files(iff)=ecrit_files(iff)*86400.
       ELSE
          CALL convers_timesteps(chtimestep(iff),dtime,ecrit_files(iff)) 
       ENDIF
       WRITE(lunout,*)'ecrit_files(',iff,')= ',ecrit_files(iff)

       zoutm(iff) = ecrit_files(iff) ! Frequence ou l on ecrit en seconde

       IF (clef_files(iff)) THEN

          idayref = day_ref
!          CALL ymds2ju(annee_ref, 1, idayref, 0.0, zjulian)       
! correction pour l heure initiale                               !jyg 
!                                                                !jyg 
          CALL ymds2ju(annee_ref, 1, idayref, hour, zjulian)         !jyg
! correction pour l heure initiale                               !jyg 
!                                                                !jyg 
!!!      CALL ymds2ju(annee_ref, 1, idayref, 0.0, zjulian)       !jyg 
! correction pour l heure initiale                               !jyg 
!                                                                !jyg 
!      CALL ymds2ju(annee_ref, 1, idayref, hour, zjulian)         !jyg

!!!!!!!!!!!!!!!!! Traitement dans le cas ou l'on veut stocker sur un domaine limite !!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
          IF (phys_out_regfkey(iff)) then

             imin_ins=1
             imax_ins=iim
             jmin_ins=1
             jmax_ins=jjmp1

             ! correction abderr        
             do i=1,iim
                WRITE(lunout,*)'io_lon(i)=',io_lon(i)
                IF (io_lon(i).le.phys_out_lonmin(iff)) imin_ins=i
                IF (io_lon(i).le.phys_out_lonmax(iff)) imax_ins=i+1
             enddo

             do j=1,jjmp1
                WRITE(lunout,*)'io_lat(j)=',io_lat(j)
                IF (io_lat(j).ge.phys_out_latmin(iff)) jmax_ins=j+1
                IF (io_lat(j).ge.phys_out_latmax(iff)) jmin_ins=j
             enddo

             WRITE(lunout,*)'On stoke le fichier histoire numero ',iff,' sur ', &
                  imin_ins,imax_ins,jmin_ins,jmax_ins
             WRITE(lunout,*)'longitudes : ', &
                  io_lon(imin_ins),io_lon(imax_ins), &
                  'latitudes : ', &
                  io_lat(jmax_ins),io_lat(jmin_ins)

             CALL histbeg(phys_out_filenames(iff),iim,io_lon,jjmp1,io_lat, &
                  imin_ins,imax_ins-imin_ins+1, &
                  jmin_ins,jmax_ins-jmin_ins+1, &
                  itau_phy,zjulian,dtime,nhorim(iff),nid_files(iff))
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
             !IM fichiers stations
          else IF (clef_stations(iff)) THEN

             WRITE(lunout,*)'phys_output_mod phys_out_filenames=',phys_out_filenames(iff)

             CALL histbeg_phy_all(rlon,rlat,pim,tabij,ipt,jpt,plon,plat,plon_bounds,plat_bounds, &
                  phys_out_filenames(iff), &
                  itau_phy,zjulian,dtime,nhorim(iff),nid_files(iff))
          else
             CALL histbeg_phy(phys_out_filenames(iff),itau_phy,zjulian,dtime,nhorim(iff),nid_files(iff))
          endif

          CALL histvert(nid_files(iff), "presnivs", "Vertical levels", "Pa", &
               levmax(iff) - levmin(iff) + 1, &
               presnivs(levmin(iff):levmax(iff)), nvertm(iff),"down")

!!!!!!!!!!!!! Traitement des champs 3D pour histhf !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!! A Revoir plus tard !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
          !          IF (iff.eq.3.and.lev_files(iff).ge.4) THEN
          !          CALL histbeg_phy("histhf3d",itau_phy, &
          !     &                     zjulian, dtime, &
          !     &                     nhorim, nid_hf3d)

          !         CALL histvert(nid_hf3d, "presnivs", &
          !     &                 "Vertical levels", "mb", &
          !     &                 klev, presnivs/100., nvertm)
          !          ENDIF
          !
!!!! Composentes de la coordonnee sigma-hybride 
          CALL histvert(nid_files(iff), "Ahyb","Ahyb comp of Hyb Cord ", "Pa", &
               levmax(iff) - levmin(iff) + 1,Ahyb,nvertap(iff))

          CALL histvert(nid_files(iff), "Bhyb","Bhyb comp of Hyb Cord", " ", &
               levmax(iff) - levmin(iff) + 1,Bhyb,nvertbp(iff))

          CALL histvert(nid_files(iff), "Alt","Height approx for scale heigh of 8km at levels", "Km", &
               levmax(iff) - levmin(iff) + 1,Alt,nvertAlt(iff))

          !   CALL histvert(nid_files(iff), "preff","Reference pressure", "Pa", &
          !                 1,preff,nvertp0(iff))
!!! Champs 1D !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    CALL histdef2d(iff,o_aire)
    CALL histdef2d(iff,o_contfracATM)

!!! Champs 2D !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    CALL histdef2d(iff,o_phis)
    CALL histdef2d(iff,o_contfracOR)
    CALL histdef2d(iff,o_aireTER)
    CALL histdef2d(iff,o_flat)
    CALL histdef2d(iff,o_slp)
    CALL histdef2d(iff,o_tsol)
    CALL histdef2d(iff,o_t2m)
    CALL histdef2d(iff,o_t2m_min)
    CALL histdef2d(iff,o_t2m_max)
    CALL histdef2d(iff,o_wind10m)
    CALL histdef2d(iff,o_wind10max)
    CALL histdef2d(iff,o_sicf)
    CALL histdef2d(iff,o_q2m)
    CALL histdef2d(iff,o_ustar)
    CALL histdef2d(iff,o_u10m)
    CALL histdef2d(iff,o_v10m)
    CALL histdef2d(iff,o_psol)
    CALL histdef2d(iff,o_qsurf)

    IF (.NOT. ok_veget) THEN
      CALL histdef2d(iff,o_qsol)
    ENDIF
    CALL histdef2d(iff,o_ndayrain)
    CALL histdef2d(iff,o_precip)
    CALL histdef2d(iff,o_plul)
    CALL histdef2d(iff,o_pluc)
    CALL histdef2d(iff,o_snow)
    CALL histdef2d(iff,o_msnow)
    CALL histdef2d(iff,o_fsnow)
    CALL histdef2d(iff,o_evap)
    CALL histdef2d(iff,o_tops)
    CALL histdef2d(iff,o_tops0)
    CALL histdef2d(iff,o_topl)
    CALL histdef2d(iff,o_topl0)
    CALL histdef2d(iff,o_SWupTOA)
    CALL histdef2d(iff,o_SWupTOAclr)
    CALL histdef2d(iff,o_SWdnTOA)
    CALL histdef2d(iff,o_SWdnTOAclr)
    CALL histdef2d(iff,o_nettop)
    CALL histdef2d(iff,o_SWup200)
    CALL histdef2d(iff,o_SWup200clr)
    CALL histdef2d(iff,o_SWdn200)
    CALL histdef2d(iff,o_SWdn200clr)
    CALL histdef2d(iff,o_LWup200)
    CALL histdef2d(iff,o_LWup200clr)
    CALL histdef2d(iff,o_LWdn200)
    CALL histdef2d(iff,o_LWdn200clr)
    CALL histdef2d(iff,o_sols)
    CALL histdef2d(iff,o_sols0)
    CALL histdef2d(iff,o_soll)
    CALL histdef2d(iff,o_radsol)
    CALL histdef2d(iff,o_soll0)
    CALL histdef2d(iff,o_SWupSFC)
    CALL histdef2d(iff,o_SWupSFCclr)
    CALL histdef2d(iff,o_SWdnSFC)
    CALL histdef2d(iff,o_SWdnSFCclr)
    CALL histdef2d(iff,o_LWupSFC)
    CALL histdef2d(iff,o_LWdnSFC)
    CALL histdef2d(iff,o_LWupSFCclr)
    CALL histdef2d(iff,o_LWdnSFCclr)
    CALL histdef2d(iff,o_bils)
    CALL histdef2d(iff,o_bils_ec)
    CALL histdef2d(iff,o_bils_tke)
    CALL histdef2d(iff,o_bils_diss)
    CALL histdef2d(iff,o_bils_kinetic)
    CALL histdef2d(iff,o_bils_enthalp)
    CALL histdef2d(iff,o_bils_latent)
    CALL histdef2d(iff,o_sens)
    CALL histdef2d(iff,o_fder)
    CALL histdef2d(iff,o_ffonte)
    CALL histdef2d(iff,o_fqcalving)
    CALL histdef2d(iff,o_fqfonte)
    CALL histdef2d(iff,o_taux)
    CALL histdef2d(iff,o_tauy)

    DO nsrf = 1, nbsrf
      CALL histdef2d(iff,o_pourc_srf(nsrf))
      CALL histdef2d(iff,o_fract_srf(nsrf))
      CALL histdef2d(iff, o_taux_srf(nsrf))
      CALL histdef2d(iff, o_tauy_srf(nsrf))
      CALL histdef2d(iff, o_tsol_srf(nsrf))
      CALL histdef2d(iff, o_evappot_srf(nsrf))
      CALL histdef2d(iff, o_ustar_srf(nsrf))
      CALL histdef2d(iff, o_u10m_srf(nsrf))
      CALL histdef2d(iff, o_evap_srf(nsrf))
      CALL histdef2d(iff, o_v10m_srf(nsrf))
      CALL histdef2d(iff, o_t2m_srf(nsrf))
      CALL histdef2d(iff, o_sens_srf(nsrf))
      CALL histdef2d(iff, o_lat_srf(nsrf))
      CALL histdef2d(iff, o_flw_srf(nsrf))
      CALL histdef2d(iff, o_fsw_srf(nsrf))
      CALL histdef2d(iff, o_wbils_srf(nsrf))
      CALL histdef2d(iff, o_wbilo_srf(nsrf))
      IF (iflag_pbl>1 ) then
            CALL histdef2d(iff, o_tke_srf(nsrf))
            CALL histdef2d(iff, o_tke_max_srf(nsrf))
      ENDIF

      CALL histdef2d(iff, o_albe_srf(nsrf))
      CALL histdef2d(iff, o_rugs_srf(nsrf))
      CALL histdef2d(iff, o_ages_srf(nsrf))
    END DO

    IF (new_aod .AND. (.NOT. aerosol_couple)) THEN
      IF (ok_ade.OR.ok_aie) THEN
          CALL histdef2d(iff,o_od550aer)
          CALL histdef2d(iff,o_od865aer)
          CALL histdef2d(iff,o_absvisaer)
          CALL histdef2d(iff,o_od550lt1aer)
          CALL histdef2d(iff,o_sconcso4)
          CALL histdef2d(iff,o_sconcoa)
          CALL histdef2d(iff,o_sconcbc)
          CALL histdef2d(iff,o_sconcss)
          CALL histdef2d(iff,o_sconcdust)
          CALL histdef3d(iff,o_concso4)
          CALL histdef3d(iff,o_concoa)
          CALL histdef3d(iff,o_concbc)
          CALL histdef3d(iff,o_concss)
          CALL histdef3d(iff,o_concdust)
          CALL histdef2d(iff,o_loadso4)
          CALL histdef2d(iff,o_loadoa)
          CALL histdef2d(iff,o_loadbc)
          CALL histdef2d(iff,o_loadss)
          CALL histdef2d(iff,o_loaddust)
!--STRAT AER
      ENDIF
      IF (ok_ade.OR.ok_aie.OR.flag_aerosol_strat) THEN
        DO naero = 1, naero_spc
          CALL histdef2d(iff, o_tausumaero(naero))
        END DO
      ENDIF
    ENDIF

    IF (ok_ade) THEN
      CALL histdef2d(iff,o_topswad)
      CALL histdef2d(iff,o_topswad0)
      CALL histdef2d(iff,o_solswad)
      CALL histdef2d(iff,o_solswad0)
      CALL histdef2d(iff,o_swtoaas_nat)
      CALL histdef2d(iff,o_swsrfas_nat)
      CALL histdef2d(iff,o_swtoacs_nat)
      CALL histdef2d(iff,o_swsrfcs_nat)
      CALL histdef2d(iff,o_swtoaas_ant)
      CALL histdef2d(iff,o_swsrfas_ant)
      CALL histdef2d(iff,o_swtoacs_ant)
      CALL histdef2d(iff,o_swsrfcs_ant)

      IF (.NOT. aerosol_couple) THEN 
            CALL histdef2d(iff,o_swtoacf_nat)
            CALL histdef2d(iff,o_swsrfcf_nat)
            CALL histdef2d(iff,o_swtoacf_ant)
            CALL histdef2d(iff,o_swsrfcf_ant)
            CALL histdef2d(iff,o_swtoacf_zero)
            CALL histdef2d(iff,o_swsrfcf_zero)
      ENDIF
    ENDIF

    IF (ok_aie) THEN
      CALL histdef2d(iff,o_topswai)
      CALL histdef2d(iff,o_solswai)
                  !Cloud droplet number concentration
      CALL histdef3d(iff,o_scdnc)
      CALL histdef2d(iff,o_cldncl)
      CALL histdef3d(iff,o_reffclws)
      CALL histdef3d(iff,o_reffclwc)
      CALL histdef2d(iff,o_cldnvi)
      CALL histdef3d(iff,o_lcc3d)
      CALL histdef3d(iff,o_lcc3dcon)
      CALL histdef3d(iff,o_lcc3dstra)
      CALL histdef2d(iff,o_lcc)
      CALL histdef2d(iff,o_reffclwtop)
    ENDIF
    CALL histdef2d(iff,o_alb1)
    CALL histdef2d(iff,o_alb2)
    CALL histdef2d(iff,o_cdrm)
    CALL histdef2d(iff,o_cdrh)
    CALL histdef2d(iff,o_cldl)
    CALL histdef2d(iff,o_cldm)
    CALL histdef2d(iff,o_cldh)
    CALL histdef2d(iff,o_cldt)
    CALL histdef2d(iff,o_cldq)
    CALL histdef2d(iff,o_lwp)
    CALL histdef2d(iff,o_iwp)
    CALL histdef2d(iff,o_ue)
    CALL histdef2d(iff,o_ve)
    CALL histdef2d(iff,o_uq)
    CALL histdef2d(iff,o_vq)

    IF(iflag_con.GE.3) THEN ! sb
      CALL histdef2d(iff,o_cape)
      CALL histdef2d(iff,o_pbase)
      CALL histdef2d(iff,o_ptop)
      CALL histdef2d(iff,o_fbase)
      IF (iflag_con /= 30) THEN
            CALL histdef2d(iff,o_plcl)
            CALL histdef2d(iff,o_plfc)
            CALL histdef2d(iff,o_wbeff)
      ENDIF
      CALL histdef2d(iff,o_cape_max)
      CALL histdef3d(iff,o_upwd)
      CALL histdef3d(iff,o_Ma)
      CALL histdef3d(iff,o_dnwd)
      CALL histdef3d(iff,o_dnwd0)
      CALL histdef3d(iff,o_mc)
      CALL histdef2d(iff,o_ftime_con)
    ENDIF !iflag_con .GE. 3
    CALL histdef2d(iff,o_prw)
    CALL histdef2d(iff,o_s_pblh)
    CALL histdef2d(iff,o_s_pblt)
    CALL histdef2d(iff,o_s_lcl)
    CALL histdef2d(iff,o_s_therm)
          !IM : Les champs suivants (s_oliqCL, s_cteiCL, s_trmb1, s_trmb2, s_trmb3) ne sont pas definis dans HBTM.F
          !CALL histdef2d(iff, &
          !o_s_capCL%flag,o_s_capCL%name, "Conv avlbl pot enerfor ABL", "J/m2" )
          !CALL histdef2d(iff, &
          !o_s_oliqCL%flag,o_s_oliqCL%name, "Liq Water in BL", "kg/m2")
          !CALL histdef2d(iff, &
          !o_s_cteiCL%flag,o_s_cteiCL%name, "Instability criteria(ABL)", "K")
          !CALL histdef2d(iff, &
          !o_s_trmb1%flag,o_s_trmb1%name, "deep_cape(HBTM2)", "J/m2")
          !CALL histdef2d(iff, &
          !o_s_trmb2%flag,o_s_trmb2%name, "inhibition (HBTM2)", "J/m2")
          !CALL histdef2d(iff, &
          !o_s_trmb3%flag,o_s_trmb3%name, "Point Omega (HBTM2)", "m")

          ! Champs interpolles sur des niveaux de pression

          ! Attention a reverifier

    ilev=0        
    DO k=1, nlevSTD
      bb2=clevSTD(k)
      IF(bb2.EQ."850".OR.bb2.EQ."700".OR.bb2.EQ."500".OR.bb2.EQ."200" &
                  .OR.bb2.EQ."100".OR.bb2.EQ."50".OR.bb2.EQ."10")THEN
            ilev=ilev+1
            !     print*,'ilev k bb2 flag name ',ilev,k, bb2,o_uSTDlevs(ilev)%flag,o_uSTDlevs(ilev)%name
            CALL histdef2d(iff,o_uSTDlevs(ilev))
            CALL histdef2d(iff,o_vSTDlevs(ilev))
            CALL histdef2d(iff,o_wSTDlevs(ilev))
            CALL histdef2d(iff,o_zSTDlevs(ilev))
            CALL histdef2d(iff,o_qSTDlevs(ilev))
            CALL histdef2d(iff,o_tSTDlevs(ilev))
      ENDIF !(bb2.EQ."850".OR.bb2.EQ."700".OR."500".OR.bb2.EQ."200".OR.bb2.EQ."50".OR.bb2.EQ."10")
    ENDDO

    CALL histdef2d(iff,o_t_oce_sic)

    IF (type_ocean=='slab') THEN
      CALL histdef2d(iff,o_slab_bils)
    ENDIF

    ! Couplage conv-CL
    IF (iflag_con.GE.3) THEN
      IF (iflag_coupl>=1) THEN
            CALL histdef2d(iff,o_ale_bl)
            CALL histdef2d(iff,o_alp_bl)
      ENDIF
    ENDIF !(iflag_con.GE.3)

    CALL histdef2d(iff,o_weakinv)
    CALL histdef2d(iff,o_dthmin)

    CALL histdef2d(iff,o_rh2m)
    CALL histdef2d(iff,o_rh2m_min)
    CALL histdef2d(iff,o_rh2m_max)

    CALL histdef2d(iff,o_qsat2m)
    CALL histdef2d(iff,o_tpot)
    CALL histdef2d(iff,o_tpote)
    CALL histdef2d(iff,o_SWnetOR)
    CALL histdef2d(iff,o_SWdownOR)
    CALL histdef2d(iff,o_LWdownOR)
    CALL histdef2d(iff,o_snowl)
    CALL histdef2d(iff,o_solldown)
    CALL histdef2d(iff,o_dtsvdfo)
    CALL histdef2d(iff,o_dtsvdft)
    CALL histdef2d(iff,o_dtsvdfg)
    CALL histdef2d(iff,o_dtsvdfi)
    CALL histdef2d(iff,o_rugs)

          ! Champs 3D:
    CALL histdef3d(iff,o_ec550aer)
    CALL histdef3d(iff,o_lwcon)
    CALL histdef3d(iff,o_iwcon)
    CALL histdef3d(iff,o_temp)
    CALL histdef3d(iff,o_theta)
    CALL histdef3d(iff,o_ovap)
    CALL histdef3d(iff,o_oliq)
    CALL histdef3d(iff,o_ovapinit)
    CALL histdef3d(iff,o_geop)
    CALL histdef3d(iff,o_vitu)
    CALL histdef3d(iff,o_vitv)
    CALL histdef3d(iff,o_vitw)
    CALL histdef3d(iff,o_pres)
    CALL histdef3d(iff,o_paprs)
    CALL histdef3d(iff,o_mass)
    CALL histdef3d(iff,o_zfull)
    CALL histdef3d(iff,o_zhalf)
    CALL histdef3d(iff,o_rneb)
    CALL histdef3d(iff,o_rnebcon)
    CALL histdef3d(iff,o_rnebls)
    CALL histdef3d(iff,o_rhum)
    CALL histdef3d(iff,o_ozone)

    IF (read_climoz == 2) THEN
      CALL histdef3d(iff,o_ozone_light)
    END IF

    CALL histdef3d(iff,o_dtphy)
    CALL histdef3d(iff,o_dqphy)
    CALL histdef3d(iff,o_cldtau)
    CALL histdef3d(iff,o_cldemi)
!IM: bug ?? dimensionnement variables (klon,klev+1) pmflxr, pmflxs, prfl, psfl
    CALL histdef3d(iff,o_pr_con_l)
    CALL histdef3d(iff,o_pr_con_i)
    CALL histdef3d(iff,o_pr_lsc_l)
    CALL histdef3d(iff,o_pr_lsc_i)
!Cloud droplet effective radius
    CALL histdef3d(iff,o_re)
    CALL histdef3d(iff,o_fl)
!FH Sorties pour la couche limite
    IF (iflag_pbl>1) THEN
      CALL histdef3d(iff,o_tke)
      CALL histdef3d(iff,o_tke_max)
    ENDIF
    CALL histdef3d(iff,o_kz)
    CALL histdef3d(iff,o_kz_max)
    CALL histdef3d(iff,o_clwcon)
    CALL histdef3d(iff,o_dtdyn)
    CALL histdef3d(iff,o_dqdyn)
    CALL histdef3d(iff,o_dudyn)
    CALL histdef3d(iff,o_dvdyn)
    CALL histdef3d(iff,o_dtcon)
    CALL histdef3d(iff,o_ducon)
    CALL histdef3d(iff,o_dvcon)
    CALL histdef3d(iff,o_dqcon)

! Wakes
    IF(iflag_con.EQ.3) THEN
      IF (iflag_wake >= 1) THEN
            CALL histdef2d(iff,o_ale_wk)
            CALL histdef2d(iff,o_alp_wk)
            CALL histdef2d(iff,o_ale)
            CALL histdef2d(iff,o_alp)
            CALL histdef2d(iff,o_cin)
            CALL histdef2d(iff,o_wape)
            CALL histdef2d(iff,o_wake_h)
            CALL histdef2d(iff,o_wake_s)
            CALL histdef3d(iff,o_dtwak)
            CALL histdef3d(iff,o_dqwak)
            CALL histdef3d(iff,o_wake_deltat)
            CALL histdef3d(iff,o_wake_deltaq)
            CALL histdef3d(iff,o_wake_omg)
      ENDIF
!!! RomP             CALL histdef3d(iff,o_Vprecip%flag,o_Vprecip%name, "precipitation vertical profile", "-")
      CALL histdef3d(iff,o_ftd)
      CALL histdef3d(iff,o_fqd)
    ENDIF !(iflag_con.EQ.3)

    IF(iflag_con.GE.3) THEN   !  RomP >>>
      CALL histdef3d(iff,o_wdtrainA)
      CALL histdef3d(iff,o_wdtrainM)
      CALL histdef3d(iff,o_Vprecip)
    ENDIF !(iflag_con.GE.3)   ! <<< RomP

!!! nrlmd le 10/04/2012

    IF (iflag_trig_bl>=1) THEN
      CALL histdef2d(iff,o_n2)
      CALL histdef2d(iff,o_s2)
      CALL histdef2d(iff,o_proba_notrig)
      CALL histdef2d(iff,o_random_notrig)
      CALL histdef2d(iff,o_ale_bl_trig)
      CALL histdef2d(iff,o_ale_bl_stat)
    ENDIF  !(iflag_trig_bl>=1)

    IF (iflag_clos_bl>=1) THEN
      CALL histdef2d(iff,o_alp_bl_det)
      CALL histdef2d(iff,o_alp_bl_fluct_m)
      CALL histdef2d(iff,o_alp_bl_fluct_tke)
      CALL histdef2d(iff,o_alp_bl_conv)
      CALL histdef2d(iff,o_alp_bl_stat)
    ENDIF  !(iflag_clos_bl>=1)

!!! fin nrlmd le 10/04/2012
    CALL histdef3d(iff,o_dtlsc)
    CALL histdef3d(iff,o_dtlschr)
    CALL histdef3d(iff,o_dqlsc)
    CALL histdef3d(iff,o_beta_prec)
    CALL histdef3d(iff,o_dtvdf)
    CALL histdef3d(iff,o_dtdis)
    CALL histdef3d(iff,o_dqvdf)
    CALL histdef3d(iff,o_dteva)
    CALL histdef3d(iff,o_dqeva)
    CALL histdef3d(iff,o_ptconv)
    CALL histdef3d(iff,o_ratqs)
    CALL histdef3d(iff,o_dtthe)

    IF (iflag_thermals.ge.1) THEN
      CALL histdef3d(iff,o_dqlscth)
      CALL histdef3d(iff,o_dqlscst)
      CALL histdef3d(iff,o_dtlscth)
      CALL histdef3d(iff,o_dtlscst)
      CALL histdef2d(iff,o_plulth)
      CALL histdef2d(iff,o_plulst)
      CALL histdef2d(iff,o_lmaxth)
      CALL histdef3d(iff,o_ptconvth)
      CALL histdef3d(iff,o_f_th)
      CALL histdef3d(iff,o_e_th)
      CALL histdef3d(iff,o_w_th)
      CALL histdef3d(iff,o_lambda_th)
      CALL histdef2d(iff,o_ftime_th)
      CALL histdef3d(iff,o_q_th)
      CALL histdef3d(iff,o_a_th)
      CALL histdef3d(iff,o_d_th)
      CALL histdef2d(iff,o_f0_th)
      CALL histdef2d(iff,o_zmax_th)
      CALL histdef3d(iff,o_dqthe)
    ENDIF !iflag_thermals.ge.1

    CALL histdef3d(iff,o_dtajs)
    CALL histdef3d(iff,o_dqajs)
    CALL histdef3d(iff,o_dtswr)
    CALL histdef3d(iff,o_dtsw0)
    CALL histdef3d(iff,o_dtlwr)
    CALL histdef3d(iff,o_dtlw0)
    CALL histdef3d(iff,o_dtec)
    CALL histdef3d(iff,o_duvdf)
    CALL histdef3d(iff,o_dvvdf)

    IF (ok_orodr) THEN
      CALL histdef3d(iff,o_duoro)
      CALL histdef3d(iff,o_dvoro)
      CALL histdef3d(iff,o_dtoro)
    ENDIF

    IF (ok_orolf) THEN
      CALL histdef3d(iff,o_dulif)
      CALL histdef3d(iff,o_dvlif)
      CALL histdef3d(iff,o_dtlif)
    ENDIF

    IF (ok_hines) then
      CALL histdef3d(iff,o_duhin)
      CALL histdef3d(iff,o_dvhin)
      CALL histdef3d(iff,o_dthin)
    ENDIF

    CALL histdef3d(iff,o_rsu)
    CALL histdef3d(iff,o_rsd)
    CALL histdef3d(iff,o_rlu)
    CALL histdef3d(iff,o_rld)
    CALL histdef3d(iff,o_rsucs)
    CALL histdef3d(iff,o_rsdcs)
    CALL histdef3d(iff,o_rlucs)
    CALL histdef3d(iff,o_rldcs)
    CALL histdef3d(iff,o_tnt)
    CALL histdef3d(iff,o_tntc)
    CALL histdef3d(iff,o_tntr)
    CALL histdef3d(iff,o_tntscpbl)
    CALL histdef3d(iff,o_tnhus)
    CALL histdef3d(iff,o_tnhusc)
    CALL histdef3d(iff,o_tnhusscpbl)
    CALL histdef3d(iff,o_evu)
    CALL histdef3d(iff,o_h2o)
    CALL histdef3d(iff,o_mcd)
    CALL histdef3d(iff,o_dmc)
    CALL histdef3d(iff,o_ref_liq)
    CALL histdef3d(iff,o_ref_ice)

    IF (RCO2_per.NE.RCO2_act.OR.RCH4_per.NE.RCH4_act.OR. &
               RN2O_per.NE.RN2O_act.OR.RCFC11_per.NE.RCFC11_act.OR. &
               RCFC12_per.NE.RCFC12_act) THEN
      CALL histdef2d(iff,o_rsut4co2)
      CALL histdef2d(iff,o_rlut4co2)
      CALL histdef2d(iff,o_rsutcs4co2)
      CALL histdef2d(iff,o_rlutcs4co2)
      CALL histdef3d(iff,o_rsu4co2)
      CALL histdef3d(iff,o_rlu4co2)
      CALL histdef3d(iff,o_rsucs4co2)
      CALL histdef3d(iff,o_rlucs4co2)
      CALL histdef3d(iff,o_rsd4co2)
      CALL histdef3d(iff,o_rld4co2)
      CALL histdef3d(iff,o_rsdcs4co2)
      CALL histdef3d(iff,o_rldcs4co2)

    ENDIF


      IF (nqtot>=3) THEN
            DO iq=3,nqtot  
            iiq=niadv(iq)
            o_trac(iq-2) = ctrl_out((/ 4, 5, 1, 1, 1, 10 /),tname(iiq),'Tracer '//ttext(iiq), "-",&
                  (/ '', '', '', '', '', '' /))
            CALL histdef3d(iff, o_trac(iq-2))
            o_trac_cum(iq-2) = ctrl_out((/ 3, 4, 10, 10, 10, 10 /),'cum'//tname(iiq),&
                  'Cumulated tracer '//ttext(iiq), "-", (/ '', '', '', '', '', '' /))
            CALL histdef2d(iff, o_trac_cum(iq-2))
            ENDDO
      ENDIF

      CALL histend(nid_files(iff))

      ndex2d = 0
      ndex3d = 0

    ENDIF ! clef_files

    ENDDO !  iff

    ! Updated write frequencies due to phys_out_filetimesteps. 
    ! Write frequencies are now in seconds.  
    ecrit_mth = ecrit_files(1)
    ecrit_day = ecrit_files(2)
    ecrit_hf  = ecrit_files(3)
    ecrit_ins = ecrit_files(4)
    ecrit_LES = ecrit_files(5)
    ecrit_ins = ecrit_files(6)

    WRITE(lunout,*)'swaero_diag=',swaero_diag
    WRITE(lunout,*)'Fin phys_output_mod.F90'
  end SUBROUTINE phys_output_open

  SUBROUTINE histdef2d_old (iff,lpoint,flag_var,nomvar,titrevar,unitvar)

    USE ioipsl
    USE dimphy
    USE mod_phys_lmdz_para
    USE iophy

    IMPLICIT NONE

    INCLUDE "dimensions.h"
    INCLUDE "temps.h"
    INCLUDE "clesphys.h"

    INTEGER                          :: iff
    LOGICAL                          :: lpoint
    INTEGER, DIMENSION(nfiles)       :: flag_var
    CHARACTER(LEN=20)                 :: nomvar
    CHARACTER(LEN=*)                 :: titrevar
    CHARACTER(LEN=*)                 :: unitvar

    REAL zstophym

    IF (type_ecri(iff)=='inst(X)'.OR.type_ecri(iff)=='once') THEN
       zstophym=zoutm(iff)
    ELSE
       zstophym=zdtime
    ENDIF

    ! Appel a la lecture des noms et niveau d'ecriture des variables dans output.def
    CALL conf_physoutputs(nomvar,flag_var)

    IF(.NOT.lpoint) THEN  
       IF ( flag_var(iff)<=lev_files(iff) ) THEN
          CALL histdef (nid_files(iff),nomvar,titrevar,unitvar, &
               iim,jj_nb,nhorim(iff), 1,1,1, -99, 32, &
               type_ecri(iff), zstophym,zoutm(iff))                
       ENDIF
    ELSE
       IF ( flag_var(iff)<=lev_files(iff) ) THEN
          CALL histdef (nid_files(iff),nomvar,titrevar,unitvar, &
               npstn,1,nhorim(iff), 1,1,1, -99, 32, &
               type_ecri(iff), zstophym,zoutm(iff))                
       ENDIF
    ENDIF

    ! Set swaero_diag=true if at least one of the concerned variables are defined 
    IF (nomvar=='topswad' .OR. nomvar=='topswai' .OR. nomvar=='solswad' .OR. nomvar=='solswai' ) THEN
       IF  ( flag_var(iff)<=lev_files(iff) ) THEN
          swaero_diag=.TRUE.
       END IF
    END IF
  END SUBROUTINE histdef2d_old

  SUBROUTINE histdef2d (iff,var)

    USE ioipsl
    USE dimphy
    USE mod_phys_lmdz_para
    USE iophy

    IMPLICIT NONE

    INCLUDE "dimensions.h"
    INCLUDE "temps.h"
    INCLUDE "clesphys.h"

    INTEGER                          :: iff
    TYPE(ctrl_out)                   :: var

    REAL zstophym
    CHARACTER(LEN=20) :: typeecrit

    ! ug On rcupre le type crit de la structure:
    !       Assez moche,  refaire si meilleure mthode...
    IF (INDEX(var%type_ecrit(iff), "once") > 0) THEN
       typeecrit = 'once'
    ELSE IF(INDEX(var%type_ecrit(iff), "t_min") > 0) THEN
       typeecrit = 't_min(X)'
    ELSE IF(INDEX(var%type_ecrit(iff), "t_max") > 0) THEN
       typeecrit = 't_max(X)'
    ELSE IF(INDEX(var%type_ecrit(iff), "inst") > 0) THEN
       typeecrit = 'inst(X)'
    ELSE
       typeecrit = type_ecri_files(iff)
    ENDIF

    IF (typeecrit=='inst(X)'.OR.typeecrit=='once') THEN
       zstophym=zoutm(iff)
    ELSE
       zstophym=zdtime
    ENDIF

    ! Appel a la lecture des noms et niveau d'ecriture des variables dans output.def
    CALL conf_physoutputs(var%name, var%flag)

    IF(.NOT.clef_stations(iff)) THEN  
       IF ( var%flag(iff)<=lev_files(iff) ) THEN
          CALL histdef (nid_files(iff), var%name, var%description, var%unit, &
               iim,jj_nb,nhorim(iff), 1,1,1, -99, 32, &
               typeecrit, zstophym,zoutm(iff))                
       ENDIF
    ELSE
       IF ( var%flag(iff)<=lev_files(iff)) THEN
          CALL histdef (nid_files(iff), var%name, var%description, var%unit, &
               npstn,1,nhorim(iff), 1,1,1, -99, 32, &
               typeecrit, zstophym,zoutm(iff))                
       ENDIF
    ENDIF

    ! Set swaero_diag=true if at least one of the concerned variables are defined 
    IF (var%name=='topswad' .OR. var%name=='topswai' .OR. var%name=='solswad' .OR. var%name=='solswai' ) THEN
       IF  ( var%flag(iff)<=lev_files(iff) ) THEN
          swaero_diag=.TRUE.
       END IF
    END IF
  END SUBROUTINE histdef2d

  SUBROUTINE histdef3d_old (iff,lpoint,flag_var,nomvar,titrevar,unitvar)

    USE ioipsl
    USE dimphy
    USE mod_phys_lmdz_para
    USE iophy

    IMPLICIT NONE

    INCLUDE "dimensions.h"
    INCLUDE "temps.h"
!    INCLUDE "indicesol.h"
    INCLUDE "clesphys.h"

    INTEGER                          :: iff
    LOGICAL                          :: lpoint
    INTEGER, DIMENSION(nfiles)       :: flag_var
    CHARACTER(LEN=20)                 :: nomvar
    CHARACTER(LEN=*)                 :: titrevar
    CHARACTER(LEN=*)                 :: unitvar

    REAL zstophym

    ! Appel a la lecture des noms et niveau d'ecriture des variables dans output.def
    CALL conf_physoutputs(nomvar,flag_var)

    IF (type_ecri(iff)=='inst(X)'.OR.type_ecri(iff)=='once') THEN
       zstophym=zoutm(iff)
    ELSE
       zstophym=zdtime
    ENDIF

    IF(.NOT.lpoint) THEN
       IF ( flag_var(iff)<=lev_files(iff) ) THEN
          CALL histdef (nid_files(iff), nomvar, titrevar, unitvar, &
               iim, jj_nb, nhorim(iff), klev, levmin(iff), &
               levmax(iff)-levmin(iff)+1, nvertm(iff), 32, type_ecri(iff), &
               zstophym, zoutm(iff))
       ENDIF
    ELSE
       IF ( flag_var(iff)<=lev_files(iff) ) THEN
          CALL histdef (nid_files(iff), nomvar, titrevar, unitvar, &
               npstn,1,nhorim(iff), klev, levmin(iff), &
               levmax(iff)-levmin(iff)+1, nvertm(iff), 32, &
               type_ecri(iff), zstophym,zoutm(iff))
       ENDIF
    ENDIF
  END SUBROUTINE histdef3d_old

  SUBROUTINE histdef3d (iff,var)

    USE ioipsl
    USE dimphy
    USE mod_phys_lmdz_para
    USE iophy

    IMPLICIT NONE

    INCLUDE "dimensions.h"
    INCLUDE "temps.h"
    INCLUDE "clesphys.h"

    INTEGER                          :: iff
    TYPE(ctrl_out)                   :: var

    REAL zstophym
    CHARACTER(LEN=20) :: typeecrit

    ! ug On rcupre le type crit de la structure:
    !       Assez moche,  refaire si meilleure mthode...
    IF (INDEX(var%type_ecrit(iff), "once") > 0) THEN
       typeecrit = 'once'
    ELSE IF(INDEX(var%type_ecrit(iff), "t_min") > 0) THEN
       typeecrit = 't_min(X)'
    ELSE IF(INDEX(var%type_ecrit(iff), "t_max") > 0) THEN
       typeecrit = 't_max(X)'
    ELSE IF(INDEX(var%type_ecrit(iff), "inst") > 0) THEN
       typeecrit = 'inst(X)'
    ELSE
       typeecrit = type_ecri_files(iff)
    ENDIF


    ! Appel a la lecture des noms et niveau d'ecriture des variables dans output.def
    CALL conf_physoutputs(var%name,var%flag)

    IF (typeecrit=='inst(X)'.OR.typeecrit=='once') THEN
       zstophym=zoutm(iff)
    ELSE
       zstophym=zdtime
    ENDIF

    IF(.NOT.clef_stations(iff)) THEN
       IF ( var%flag(iff)<=lev_files(iff) ) THEN
          CALL histdef (nid_files(iff), var%name, var%description, var%unit, &
               iim, jj_nb, nhorim(iff), klev, levmin(iff), &
               levmax(iff)-levmin(iff)+1, nvertm(iff), 32, typeecrit, &
               zstophym, zoutm(iff))
       ENDIF
    ELSE
       IF ( var%flag(iff)<=lev_files(iff)) THEN
          CALL histdef (nid_files(iff), var%name, var%description, var%unit, &
               npstn,1,nhorim(iff), klev, levmin(iff), &
               levmax(iff)-levmin(iff)+1, nvertm(iff), 32, &
               typeecrit, zstophym,zoutm(iff))
       ENDIF
    ENDIF
  END SUBROUTINE histdef3d

  SUBROUTINE conf_physoutputs(nam_var,flag_var)
!!! Lecture des noms et niveau de sortie des variables dans output.def
    !   en utilisant les routines getin de IOIPSL  
    use ioipsl

    IMPLICIT NONE

    include 'iniprint.h'

    CHARACTER(LEN=20)                :: nam_var
    INTEGER, DIMENSION(nfiles)      :: flag_var

    IF(prt_level>10) WRITE(lunout,*)'Avant getin: nam_var flag_var ',nam_var,flag_var(:)
    CALL getin('flag_'//nam_var,flag_var)
    CALL getin('name_'//nam_var,nam_var)
    IF(prt_level>10) WRITE(lunout,*)'Apres getin: nam_var flag_var ',nam_var,flag_var(:)

  END SUBROUTINE conf_physoutputs

  SUBROUTINE convers_timesteps(str,dtime,timestep)

    use ioipsl
    USE phys_cal_mod

    IMPLICIT NONE

    CHARACTER(LEN=20)   :: str
    CHARACTER(LEN=10)   :: type
    INTEGER             :: ipos,il
    real                :: ttt,xxx,timestep,dayseconde,dtime
    parameter (dayseconde=86400.)
    include "temps.h"
    include "comconst.h"
    include "iniprint.h"

    ipos=scan(str,'0123456789.',.TRUE.)
    !  
    il=len_trim(str)
    WRITE(lunout,*)ipos,il
    read(str(1:ipos),*) ttt
    WRITE(lunout,*)ttt
    type=str(ipos+1:il)


    IF ( il == ipos ) then
       type='day'
    endif

    IF ( type == 'day'.or.type == 'days'.or.type == 'jours'.or.type == 'jour' ) timestep = ttt * dayseconde
    IF ( type == 'mounths'.or.type == 'mth'.or.type == 'mois' ) then
       WRITE(lunout,*)'annee_ref,day_ref mon_len',annee_ref,day_ref,mth_len
       timestep = ttt * dayseconde * mth_len
    endif
    IF ( type == 'hours'.or.type == 'hr'.or.type == 'heurs') timestep = ttt * dayseconde / 24.
    IF ( type == 'mn'.or.type == 'minutes'  ) timestep = ttt * 60.
    IF ( type == 's'.or.type == 'sec'.or.type == 'secondes'   ) timestep = ttt
    IF ( type == 'TS' ) timestep = ttt * dtime

    WRITE(lunout,*)'type =      ',type
    WRITE(lunout,*)'nb j/h/m =  ',ttt
    WRITE(lunout,*)'timestep(s)=',timestep

  END SUBROUTINE convers_timesteps

END MODULE phys_output_mod

