MODULE nrtype

  implicit none

  integer, parameter:: wp = kind(0.) ! working precision for real type

  ! Frequently used mathematical constants (with precision to spare):

  REAL, PARAMETER :: PI=3.141592653589793238462643383279502884197
  REAL, PARAMETER :: PIO2=1.57079632679489661923132169163975144209858
  REAL, PARAMETER :: TWOPI=6.283185307179586476925286766559005768394
  REAL, PARAMETER :: SQRT2=1.41421356237309504880168872420969807856967
  REAL, PARAMETER :: EULER=0.5772156649015328606065120900824024310422

  DOUBLE PRECISION, PARAMETER:: &
       PI_D = 3.141592653589793238462643383279502884197d0
  DOUBLE PRECISION, PARAMETER:: &
       PIO2_D=1.57079632679489661923132169163975144209858d0
  DOUBLE PRECISION, PARAMETER:: &
       TWOPI_D=6.283185307179586476925286766559005768394d0

  ! Derived data types for sparse matrices, single and double
  ! precision (see use in Chapter B2):

  TYPE sprs2_sp
     INTEGER :: n,len
     REAL, DIMENSION(:), POINTER :: val
     INTEGER, DIMENSION(:), POINTER :: irow
     INTEGER, DIMENSION(:), POINTER :: jcol
  END TYPE sprs2_sp

  TYPE sprs2_dp
     INTEGER :: n,len
     DOUBLE PRECISION, DIMENSION(:), POINTER :: val
     INTEGER, DIMENSION(:), POINTER :: irow
     INTEGER, DIMENSION(:), POINTER :: jcol
  END TYPE sprs2_dp

END MODULE nrtype
