!
! $Id: phys_local_var_mod.F90 1742 2013-04-05 11:49:35Z idelkadi $
!
      MODULE phys_local_var_mod

! Variables locales pour effectuer les appels en serie
!======================================================================
!
!
!======================================================================
! Declaration des variables

      REAL, SAVE, ALLOCATABLE :: t_seri(:,:), q_seri(:,:)
      !$OMP THREADPRIVATE(t_seri, q_seri)
      REAL, SAVE, ALLOCATABLE :: ql_seri(:,:),qs_seri(:,:)
      !$OMP THREADPRIVATE(ql_seri,qs_seri)
      REAL, SAVE, ALLOCATABLE :: u_seri(:,:), v_seri(:,:)
      !$OMP THREADPRIVATE(u_seri, v_seri)

      REAL, SAVE, ALLOCATABLE :: tr_seri(:,:,:)
      !$OMP THREADPRIVATE(tr_seri)
      REAL, SAVE, ALLOCATABLE :: d_t_dyn(:,:), d_q_dyn(:,:)
      !$OMP THREADPRIVATE(d_t_dyn, d_q_dyn)
      REAL, SAVE, ALLOCATABLE :: d_u_dyn(:,:), d_v_dyn(:,:)
      !$OMP THREADPRIVATE(d_u_dyn, d_v_dyn)
!!!!
      REAL, SAVE, ALLOCATABLE :: d_tr_dyn(:,:,:)
      !$OMP THREADPRIVATE(d_tr_dyn)
!!!!
      REAL, SAVE, ALLOCATABLE :: d_t_con(:,:),d_q_con(:,:)
      !$OMP THREADPRIVATE(d_t_con,d_q_con)
      REAL, SAVE, ALLOCATABLE :: d_u_con(:,:),d_v_con(:,:)
      !$OMP THREADPRIVATE(d_u_con,d_v_con)
      REAL, SAVE, ALLOCATABLE :: d_t_wake(:,:),d_q_wake(:,:)
      !$OMP THREADPRIVATE( d_t_wake,d_q_wake)
      REAL, SAVE, ALLOCATABLE :: d_t_lsc(:,:),d_q_lsc(:,:),d_ql_lsc(:,:)
      !$OMP THREADPRIVATE(d_t_lsc,d_q_lsc,d_ql_lsc)
      REAL, SAVE, ALLOCATABLE :: d_t_ajsb(:,:), d_q_ajsb(:,:)
      !$OMP THREADPRIVATE(d_t_ajsb, d_q_ajsb)
      REAL, SAVE, ALLOCATABLE :: d_t_ajs(:,:), d_q_ajs(:,:)
      !$OMP THREADPRIVATE(d_t_ajs, d_q_ajs)
      REAL, SAVE, ALLOCATABLE :: d_u_ajs(:,:), d_v_ajs(:,:)
      !$OMP THREADPRIVATE(d_u_ajs, d_v_ajs)
      REAL, SAVE, ALLOCATABLE :: d_t_eva(:,:),d_q_eva(:,:)
      !$OMP THREADPRIVATE(d_t_eva,d_q_eva)
      REAL, SAVE, ALLOCATABLE :: d_t_lscst(:,:),d_q_lscst(:,:)
      !$OMP THREADPRIVATE(d_t_lscst,d_q_lscst)
      REAL, SAVE, ALLOCATABLE :: d_t_lscth(:,:),d_q_lscth(:,:)
      !$OMP THREADPRIVATE(d_t_lscth,d_q_lscth)
      REAL, SAVE, ALLOCATABLE :: plul_th(:),plul_st(:)
      !$OMP THREADPRIVATE(plul_th,plul_st)
!tendances dues a oro et lif
      REAL, SAVE, ALLOCATABLE :: d_t_oli(:,:)
      !$OMP THREADPRIVATE(d_t_oli)
      REAL, SAVE, ALLOCATABLE :: d_u_oli(:,:), d_v_oli(:,:)
      !$OMP THREADPRIVATE(d_u_oli, d_v_oli)
      REAL, SAVE, ALLOCATABLE :: d_t_vdf(:,:), d_q_vdf(:,:)
      !$OMP THREADPRIVATE( d_t_vdf, d_q_vdf)
      REAL, SAVE, ALLOCATABLE :: d_u_vdf(:,:), d_v_vdf(:,:)
      !$OMP THREADPRIVATE(d_u_vdf, d_v_vdf)
      REAL, SAVE, ALLOCATABLE :: d_t_oro(:,:)
      !$OMP THREADPRIVATE(d_t_oro)
      REAL, SAVE, ALLOCATABLE :: d_u_oro(:,:), d_v_oro(:,:)
      !$OMP THREADPRIVATE(d_u_oro, d_v_oro)
      REAL, SAVE, ALLOCATABLE :: d_t_lif(:,:)
      !$OMP THREADPRIVATE(d_t_lif)
      REAL, SAVE, ALLOCATABLE :: d_u_lif(:,:), d_v_lif(:,:)
      !$OMP THREADPRIVATE(d_u_lif, d_v_lif)
! Tendances Ondes de G non oro (runs strato).
      REAL, SAVE, ALLOCATABLE :: d_u_hin(:,:)
      !$OMP THREADPRIVATE(d_u_hin)
      REAL, SAVE, ALLOCATABLE :: d_v_hin(:,:)
      !$OMP THREADPRIVATE(d_v_hin)
      REAL, SAVE, ALLOCATABLE :: d_t_hin(:,:)
      !$OMP THREADPRIVATE(d_t_hin)

! tendance du a la conersion Ec -> E thermique
      REAL, SAVE, ALLOCATABLE :: d_t_ec(:,:)
      !$OMP THREADPRIVATE(d_t_ec)
      REAL, SAVE, ALLOCATABLE :: d_ts(:,:), d_tr(:,:,:)
      !$OMP THREADPRIVATE(d_ts, d_tr)

! diagnostique pour le rayonnement
      REAL, SAVE, ALLOCATABLE :: topswad_aero(:),  solswad_aero(:)      ! diag
      !$OMP THREADPRIVATE(topswad_aero,solswad_aero)
      REAL, SAVE, ALLOCATABLE :: topswai_aero(:),  solswai_aero(:)      ! diag
      !$OMP THREADPRIVATE(topswai_aero,solswai_aero)
      REAL, SAVE, ALLOCATABLE :: topswad0_aero(:), solswad0_aero(:)     ! diag
      !$OMP THREADPRIVATE(topswad0_aero,solswad0_aero)
      REAL, SAVE, ALLOCATABLE :: topsw_aero(:,:),  solsw_aero(:,:)      ! diag
      !$OMP THREADPRIVATE(topsw_aero,solsw_aero)
      REAL, SAVE, ALLOCATABLE :: topsw0_aero(:,:), solsw0_aero(:,:)     ! diag
      !$OMP THREADPRIVATE(topsw0_aero,solsw0_aero)
      REAL, SAVE, ALLOCATABLE :: topswcf_aero(:,:),  solswcf_aero(:,:)  ! diag
      !$OMP THREADPRIVATE(topswcf_aero,solswcf_aero)
      REAL, SAVE, ALLOCATABLE :: tausum_aero(:,:,:) 
      !$OMP THREADPRIVATE(tausum_aero) 
      REAL, SAVE, ALLOCATABLE :: tau3d_aero(:,:,:,:) 
      !$OMP THREADPRIVATE(tau3d_aero) 
      REAL, SAVE, ALLOCATABLE :: scdnc(:,:)
      !$OMP THREADPRIVATE(scdnc)
      REAL, SAVE, ALLOCATABLE :: cldncl(:)
      !$OMP THREADPRIVATE(cldncl)
      REAL, SAVE, ALLOCATABLE :: reffclwtop(:)
      !$OMP THREADPRIVATE(reffclwtop)
      REAL, SAVE, ALLOCATABLE :: lcc(:)
      !$OMP THREADPRIVATE(lcc)
      REAL, SAVE, ALLOCATABLE :: reffclws(:,:)
      !$OMP THREADPRIVATE(reffclws)
      REAL, SAVE, ALLOCATABLE :: reffclwc(:,:)
      !$OMP THREADPRIVATE(reffclwc)
      REAL, SAVE, ALLOCATABLE :: cldnvi(:) 
      !$OMP THREADPRIVATE(cldnvi)
      REAL, SAVE, ALLOCATABLE :: lcc3d(:,:)
      !$OMP THREADPRIVATE(lcc3d)
      REAL, SAVE, ALLOCATABLE :: lcc3dcon(:,:)
      !$OMP THREADPRIVATE(lcc3dcon)
      REAL, SAVE, ALLOCATABLE :: lcc3dstra(:,:)
      !$OMP THREADPRIVATE(lcc3dstra)
      REAL, SAVE, ALLOCATABLE :: od550aer(:) 
      !$OMP THREADPRIVATE(od550aer) 
      REAL, SAVE, ALLOCATABLE :: absvisaer(:) 
      !$OMP THREADPRIVATE(absvisaer) 
      REAL, SAVE, ALLOCATABLE :: od865aer(:) 
      !$OMP THREADPRIVATE(od865aer) 
      REAL, SAVE, ALLOCATABLE :: ec550aer(:,:) 
      !$OMP THREADPRIVATE(ec550aer) 
      REAL, SAVE, ALLOCATABLE :: od550lt1aer(:) 
      !$OMP THREADPRIVATE(od550lt1aer) 
      REAL, SAVE, ALLOCATABLE :: sconcso4(:) 
      !$OMP THREADPRIVATE(sconcso4) 
      REAL, SAVE, ALLOCATABLE :: sconcoa(:) 
      !$OMP THREADPRIVATE(sconcoa) 
      REAL, SAVE, ALLOCATABLE :: sconcbc(:) 
      !$OMP THREADPRIVATE(sconcbc) 
      REAL, SAVE, ALLOCATABLE :: sconcss(:) 
      !$OMP THREADPRIVATE(sconcss) 
      REAL, SAVE, ALLOCATABLE :: sconcdust(:) 
      !$OMP THREADPRIVATE(sconcdust) 
      REAL, SAVE, ALLOCATABLE :: concso4(:,:) 
      !$OMP THREADPRIVATE(concso4) 
      REAL, SAVE, ALLOCATABLE :: concoa(:,:) 
      !$OMP THREADPRIVATE(concoa) 
      REAL, SAVE, ALLOCATABLE :: concbc(:,:) 
      !$OMP THREADPRIVATE(concbc) 
      REAL, SAVE, ALLOCATABLE :: concss(:,:) 
      !$OMP THREADPRIVATE(concss) 
      REAL, SAVE, ALLOCATABLE :: concdust(:,:) 
      !$OMP THREADPRIVATE(concdust) 
      REAL, SAVE, ALLOCATABLE :: loadso4(:) 
      !$OMP THREADPRIVATE(loadso4) 
      REAL, SAVE, ALLOCATABLE :: loadoa(:) 
      !$OMP THREADPRIVATE(loadoa) 
      REAL, SAVE, ALLOCATABLE :: loadbc(:) 
      !$OMP THREADPRIVATE(loadbc) 
      REAL, SAVE, ALLOCATABLE :: loadss(:) 
      !$OMP THREADPRIVATE(loadss) 
      REAL, SAVE, ALLOCATABLE :: loaddust(:) 
      !$OMP THREADPRIVATE(loaddust) 
      REAL, SAVE, ALLOCATABLE :: load_tmp1(:) 
      !$OMP THREADPRIVATE(load_tmp1) 
      REAL, SAVE, ALLOCATABLE :: load_tmp2(:) 
      !$OMP THREADPRIVATE(load_tmp2) 
      REAL, SAVE, ALLOCATABLE :: load_tmp3(:) 
      !$OMP THREADPRIVATE(load_tmp3) 
      REAL, SAVE, ALLOCATABLE :: load_tmp4(:) 
      !$OMP THREADPRIVATE(load_tmp4) 
      REAL, SAVE, ALLOCATABLE :: load_tmp5(:) 
      !$OMP THREADPRIVATE(load_tmp5) 
      REAL, SAVE, ALLOCATABLE :: load_tmp6(:) 
      !$OMP THREADPRIVATE(load_tmp6) 
      REAL, SAVE, ALLOCATABLE :: load_tmp7(:) 
      !$OMP THREADPRIVATE(load_tmp7) 

!IM ajout variables CFMIP2/CMIP5
      REAL,ALLOCATABLE,SAVE :: topswad_aerop(:), solswad_aerop(:)
!$OMP THREADPRIVATE(topswad_aerop, solswad_aerop)
      REAL,ALLOCATABLE,SAVE :: topswai_aerop(:), solswai_aerop(:)
!$OMP THREADPRIVATE(topswai_aerop, solswai_aerop)
      REAL,ALLOCATABLE,SAVE :: topswad0_aerop(:), solswad0_aerop(:)
!$OMP THREADPRIVATE(topswad0_aerop, solswad0_aerop)
      REAL,ALLOCATABLE,SAVE :: topsw_aerop(:,:), topsw0_aerop(:,:)  
!$OMP THREADPRIVATE(topsw_aerop, topsw0_aerop)
      REAL,ALLOCATABLE,SAVE :: solsw_aerop(:,:), solsw0_aerop(:,:)
!$OMP THREADPRIVATE(solsw_aerop, solsw0_aerop)
      REAL,ALLOCATABLE,SAVE :: topswcf_aerop(:,:), solswcf_aerop(:,:)
!$OMP THREADPRIVATE(topswcf_aerop, solswcf_aerop)

CONTAINS

!======================================================================
SUBROUTINE phys_local_var_init
use dimphy
use infotrac, ONLY : nbtr
USE aero_mod

IMPLICIT NONE
#include "indicesol.h"
      allocate(t_seri(klon,klev),q_seri(klon,klev),ql_seri(klon,klev),qs_seri(klon,klev))
      allocate(u_seri(klon,klev),v_seri(klon,klev))

      allocate(tr_seri(klon,klev,nbtr))
      allocate(d_t_dyn(klon,klev),d_q_dyn(klon,klev))
      allocate(d_u_dyn(klon,klev),d_v_dyn(klon,klev))
      allocate(d_tr_dyn(klon,klev,nbtr))                   !RomP
      allocate(d_t_con(klon,klev),d_q_con(klon,klev))
      allocate(d_u_con(klon,klev),d_v_con(klon,klev))
      allocate(d_t_wake(klon,klev),d_q_wake(klon,klev))
      allocate(d_t_lsc(klon,klev),d_q_lsc(klon,klev))
      allocate(d_ql_lsc(klon,klev))
      allocate(d_t_ajsb(klon,klev),d_q_ajsb(klon,klev))
      allocate(d_t_ajs(klon,klev),d_q_ajs(klon,klev))
      allocate(d_u_ajs(klon,klev),d_v_ajs(klon,klev))
      allocate(d_t_eva(klon,klev),d_q_eva(klon,klev))
      allocate(d_t_lscst(klon,klev),d_q_lscst(klon,klev))
      allocate(d_t_lscth(klon,klev),d_q_lscth(klon,klev))
      allocate(plul_st(klon),plul_th(klon))
      allocate(d_t_vdf(klon,klev),d_q_vdf(klon,klev))
      allocate(d_u_vdf(klon,klev),d_v_vdf(klon,klev))
      allocate(d_t_oli(klon,klev),d_t_oro(klon,klev))
      allocate(d_u_oli(klon,klev),d_v_oli(klon,klev))
      allocate(d_u_oro(klon,klev),d_v_oro(klon,klev))
      allocate(d_t_lif(klon,klev),d_t_ec(klon,klev))
      allocate(d_u_lif(klon,klev),d_v_lif(klon,klev))
      allocate(d_ts(klon,nbsrf), d_tr(klon,klev,nbtr))
      allocate(topswad_aero(klon), solswad_aero(klon))
      allocate(topswai_aero(klon), solswai_aero(klon))
      allocate(topswad0_aero(klon), solswad0_aero(klon))
      allocate(topsw_aero(klon,naero_grp), solsw_aero(klon,naero_grp))
      allocate(topsw0_aero(klon,naero_grp), solsw0_aero(klon,naero_grp))
      allocate(topswcf_aero(klon,3), solswcf_aero(klon,3))
      allocate(d_u_hin(klon,klev),d_v_hin(klon,klev),d_t_hin(klon,klev))
      allocate(tausum_aero(klon,nwave,naero_spc))
      allocate(tau3d_aero(klon,klev,nwave,naero_spc)) 
      allocate(scdnc(klon, klev))
      allocate(cldncl(klon))
      allocate(reffclwtop(klon))
      allocate(lcc(klon))
      allocate(reffclws(klon, klev))
      allocate(reffclwc(klon, klev))
      allocate(cldnvi(klon))
      allocate(lcc3d(klon, klev))
      allocate(lcc3dcon(klon, klev))
      allocate(lcc3dstra(klon, klev))
      allocate(od550aer(klon))	 
      allocate(od865aer(klon))	 
      allocate(absvisaer(klon))	 
      allocate(ec550aer(klon,klev))
      allocate(od550lt1aer(klon))	 	 
      allocate(sconcso4(klon))
      allocate(sconcoa(klon))
      allocate(sconcbc(klon))
      allocate(sconcss(klon))
      allocate(sconcdust(klon))
      allocate(concso4(klon,klev))
      allocate(concoa(klon,klev))
      allocate(concbc(klon,klev))
      allocate(concss(klon,klev))
      allocate(concdust(klon,klev))
      allocate(loadso4(klon))
      allocate(loadoa(klon))
      allocate(loadbc(klon))
      allocate(loadss(klon))
      allocate(loaddust(klon))
      allocate(load_tmp1(klon))
      allocate(load_tmp2(klon))
      allocate(load_tmp3(klon))
      allocate(load_tmp4(klon))
      allocate(load_tmp5(klon))
      allocate(load_tmp6(klon))
      allocate(load_tmp7(klon))

!IM ajout variables CFMIP2/CMIP5
      ALLOCATE(topswad_aerop(klon), solswad_aerop(klon))
      ALLOCATE(topswai_aerop(klon), solswai_aerop(klon))
      ALLOCATE(topswad0_aerop(klon), solswad0_aerop(klon))
      ALLOCATE(topsw_aerop(klon,naero_grp), topsw0_aerop(klon,naero_grp))
      ALLOCATE(solsw_aerop(klon,naero_grp), solsw0_aerop(klon,naero_grp))
      ALLOCATE(topswcf_aerop(klon,naero_grp), solswcf_aerop(klon,naero_grp))

END SUBROUTINE phys_local_var_init

!======================================================================
SUBROUTINE phys_local_var_end
use dimphy
IMPLICIT NONE
#include "indicesol.h"
      deallocate(t_seri,q_seri,ql_seri,qs_seri)
      deallocate(u_seri,v_seri)

      deallocate(tr_seri)
      deallocate(d_t_dyn,d_q_dyn)
      deallocate(d_u_dyn,d_v_dyn)
      deallocate(d_tr_dyn)                      !RomP
      deallocate(d_t_con,d_q_con)
      deallocate(d_u_con,d_v_con)
      deallocate(d_t_wake,d_q_wake)
      deallocate(d_t_lsc,d_q_lsc)
      deallocate(d_ql_lsc)
      deallocate(d_t_ajsb,d_q_ajsb)
      deallocate(d_t_ajs,d_q_ajs)
      deallocate(d_u_ajs,d_v_ajs)
      deallocate(d_t_eva,d_q_eva)
      deallocate(d_t_lscst,d_q_lscst)
      deallocate(d_t_lscth,d_q_lscth)
      deallocate(plul_st,plul_th)
      deallocate(d_t_vdf,d_q_vdf)
      deallocate(d_u_vdf,d_v_vdf)
      deallocate(d_t_oli,d_t_oro)
      deallocate(d_u_oli,d_v_oli)
      deallocate(d_u_oro,d_v_oro)
      deallocate(d_t_lif,d_t_ec)
      deallocate(d_u_lif,d_v_lif)
      deallocate(d_ts, d_tr)
      deallocate(topswad_aero,solswad_aero)
      deallocate(topswai_aero,solswai_aero)
      deallocate(topswad0_aero,solswad0_aero)
      deallocate(topsw_aero,solsw_aero)
      deallocate(topsw0_aero,solsw0_aero)
      deallocate(topswcf_aero,solswcf_aero)
      deallocate(tausum_aero) 
      deallocate(tau3d_aero) 
      deallocate(scdnc)
      deallocate(cldncl)
      deallocate(reffclwtop)
      deallocate(lcc)
      deallocate(reffclws)
      deallocate(reffclwc)
      deallocate(cldnvi)
      deallocate(lcc3d)
      deallocate(lcc3dcon)
      deallocate(lcc3dstra)
      deallocate(od550aer)	 
      deallocate(od865aer)
      deallocate(absvisaer)
      deallocate(ec550aer)
      deallocate(od550lt1aer)
      deallocate(sconcso4) 
      deallocate(sconcoa) 
      deallocate(sconcbc) 
      deallocate(sconcss) 
      deallocate(sconcdust) 
      deallocate(concso4) 
      deallocate(concoa) 
      deallocate(concbc) 
      deallocate(concss) 
      deallocate(concdust) 
      deallocate(loadso4) 
      deallocate(loadoa) 
      deallocate(loadbc) 
      deallocate(loadss) 
      deallocate(loaddust) 
      deallocate(load_tmp1)
      deallocate(load_tmp2)
      deallocate(load_tmp3)
      deallocate(load_tmp4)
      deallocate(load_tmp5)
      deallocate(load_tmp6)
      deallocate(load_tmp7)
      deallocate(d_u_hin,d_v_hin,d_t_hin)

!IM ajout variables CFMIP2/CMIP5
      deallocate(topswad_aerop, solswad_aerop)
      deallocate(topswai_aerop, solswai_aerop)
      deallocate(topswad0_aerop, solswad0_aerop)
      deallocate(topsw_aerop, topsw0_aerop)
      deallocate(solsw_aerop, solsw0_aerop)
      deallocate(topswcf_aerop, solswcf_aerop)

END SUBROUTINE phys_local_var_end

END MODULE phys_local_var_mod
