      PROGRAM lmdz1d

      USE ioipsl, only: ju2ymds, ymds2ju, ioconf_calendar
      use phys_state_var_mod
      use comgeomphy
      use dimphy
      use surface_data, only : type_ocean,ok_veget
      use pbl_surface_mod, only : pbl_surface_init, pbl_surface_final
      use fonte_neige_mod, only : fonte_neige_init, fonte_neige_final 

      use infotrac ! new
      use control_mod

      implicit none
#include "dimensions.h"
#include "YOMCST.h"
#include "temps.h"
!!#include "control.h"
#include "iniprint.h"
#include "clesphys.h"
#include "dimsoil.h"
#include "indicesol.h"

#include "comvert.h"
#include "compar1d.h"
#include "flux_arp.h"
#include "fcg_gcssold.h"
!!!#include "fbforcing.h"

!=====================================================================
! DECLARATIONS
!=====================================================================

!---------------------------------------------------------------------
!  Externals
!---------------------------------------------------------------------
      external fq_sat
      real fq_sat

!---------------------------------------------------------------------
!  Arguments d' initialisations de la physique (USER DEFINE)
!---------------------------------------------------------------------

      integer, parameter :: ngrid=1
      real :: zcufi    = 1.
      real :: zcvfi    = 1.

!-      real :: nat_surf
!-      logical :: ok_flux_surf
!-      real :: fsens
!-      real :: flat
!-      real :: tsurf
!-      real :: rugos
!-      real :: qsol(1:2)
!-      real :: qsurf
!-      real :: psurf
!-      real :: zsurf
!-      real :: albedo
!-
!-      real :: time     = 0.
!-      real :: time_ini
!-      real :: xlat 
!-      real :: xlon 
!-      real :: wtsurf 
!-      real :: wqsurf 
!-      real :: restart_runoff 
!-      real :: xagesno 
!-      real :: qsolinp 
!-      real :: zpicinp 
!-
      real :: fnday 
      real :: day, daytime 
      real :: day1
      real :: heure
      integer :: jour
      integer :: mois
      integer :: an
 
!
      real :: paire    = 1.     ! aire de la maille
!**      common /flux_arp/fsens,flat,ok_flux_surf

!---------------------------------------------------------------------
!  Declarations related to forcing and initial profiles 
!---------------------------------------------------------------------

        integer :: kmax = llm
        integer nlev_max
        parameter (nlev_max = 100)
        real timestep, frac, timeit
        real height(nlev_max),tttprof(nlev_max),qtprof(nlev_max),
     .              uprof(nlev_max),vprof(nlev_max),e12prof(nlev_max),
     .              ugprof(nlev_max),vgprof(nlev_max),wfls(nlev_max),
     .              dqtdxls(nlev_max),dqtdyls(nlev_max),
     .              dqtdtls(nlev_max),thlpcar(nlev_max)

        real    :: fff
c        integer :: forcing_type
        logical :: forcing_les     = .false.
        logical :: forcing_armcu  = .false.
        logical :: forcing_rico    = .false.
        logical :: forcing_radconv = .false.
        logical :: forcing_toga    = .false.
        logical :: forcing_twpice  = .false.
        logical :: forcing_GCM2SCM = .false.
        logical :: forcing_GCSSold = .false.
        integer :: type_ts_forcing ! 0 = SST constant; 1 = SST read from a file
!                                                            (cf read_tsurf1d.F)

!vertical advection computation
        real d_t_z(llm), d_q_z(llm)
        real d_t_dyn_z(llm), d_q_dyn_z(llm)
        real zz(llm)
        real zfact

!flag forcings
        logical :: nudge_wind=.true.
        logical :: nudge_thermo=.false.
        logical :: cptadvw=.true.
!=====================================================================
! DECLARATIONS FOR EACH CASE
!=====================================================================
!
#include "1D_decl_cases.h"
!
!---------------------------------------------------------------------
!  Declarations related to vertical discretization:
!---------------------------------------------------------------------
      real :: pzero=1.e5
      real :: play (llm),zlay (llm),sig_s(llm),plev(llm+1)
      real :: playd(llm),zlayd(llm)

!---------------------------------------------------------------------
!  Declarations related to variables
!---------------------------------------------------------------------

      integer :: iq
      real :: phi(llm)
      real :: teta(llm),temp(llm),u(llm),v(llm)
      real :: omega(llm+1),omega2(llm),rho(llm+1)
      real :: ug(llm),vg(llm),fcoriolis
      real :: du_phys(llm),dv_phys(llm),dt_phys(llm)
      real :: du_dyn(llm),dv_dyn(llm),dt_dyn(llm)
      real :: dt_cooling(llm),d_t_cool(llm),d_th_adv(llm)
      real :: dq_cooling(llm),d_q_cool(llm)
      real :: tmpvar(llm)
      real :: alpha

      REAL, ALLOCATABLE, DIMENSION(:,:):: q
      REAL, ALLOCATABLE, DIMENSION(:,:):: dq
      REAL, ALLOCATABLE, DIMENSION(:,:):: dq_dyn
      REAL, ALLOCATABLE, DIMENSION(:,:):: d_q_adv

!---------------------------------------------------------------------
!  Initialization of surface variables
!---------------------------------------------------------------------
      real :: run_off_lic_0(1)
      real :: fder(1),snsrf(1,nbsrf),qsurfsrf(1,nbsrf)
      real :: evap(1,nbsrf),frugs(1,nbsrf)
      real :: tsoil(1,nsoilmx,nbsrf)
      real :: agesno(1,nbsrf)

!---------------------------------------------------------------------
!  Call to phyredem
!---------------------------------------------------------------------
      logical :: ok_writedem =.true.
      
!---------------------------------------------------------------------
!  Call to physiq
!---------------------------------------------------------------------
      integer, parameter :: longcles=20
      logical :: firstcall=.true.
      logical :: lastcall=.false.
      real :: phis    = 0.0
      real :: clesphy0(longcles) = 0.0
      real :: dpsrf 

!---------------------------------------------------------------------
!  Initializations of boundary conditions 
!---------------------------------------------------------------------
      integer, parameter :: yd = 360
      real :: phy_nat (yd) = 0.0 ! 0=ocean libre,1=land,2=glacier,3=banquise
      real :: phy_alb (yd)  ! Albedo land only (old value condsurf_jyg=0.3)
      real :: phy_sst (yd)  ! SST (will not be used; cf read_tsurf1d.F)
      real :: phy_bil (yd) = 1.0 ! Ne sert que pour les slab_ocean
      real :: phy_rug (yd) ! Longueur rugosite utilisee sur land only
      real :: phy_ice (yd) = 0.0 ! Fraction de glace
      real :: phy_fter(yd) = 0.0 ! Fraction de terre
      real :: phy_foce(yd) = 0.0 ! Fraction de ocean
      real :: phy_fsic(yd) = 0.0 ! Fraction de glace
      real :: phy_flic(yd) = 0.0 ! Fraction de glace

!---------------------------------------------------------------------
!  Fichiers et d'autres variables
!---------------------------------------------------------------------
      real ttt
      integer :: ierr,k,l,i,it=1,mxcalc
      integer jjmp1
      parameter (jjmp1=jjm+1-1/jjm)
      INTEGER nbteta
      PARAMETER(nbteta=3)
      REAL dudyn(iim+1,jjmp1,llm)
      REAL PVteta(1,nbteta)
      INTEGER read_climoz 
!Al1
      integer ecrit_slab_oc !1=ecrit,-1=lit,0=no file
      data ecrit_slab_oc/-1/

!=====================================================================
! INITIALIZATIONS 
!=====================================================================
! Initialization of Common turb_forcing
       dtime_frcg = 0.
       Turb_fcg_gcssold=.false.
       hthturb_gcssold = 0.
       hqturb_gcssold = 0.

!---------------------------------------------------------------------
! OPTIONS OF THE 1D SIMULATION (lmdz1d.def => unicol.def)
!---------------------------------------------------------------------
cAl1
        call conf_unicol(99)
cAl1 moves this gcssold var from common fcg_gcssold to 
        Turb_fcg_gcssold = xTurb_fcg_gcssold
c --------------------------------------------------------------------
        close(1)
cAl1
        write(*,*) 'lmdz1d.def lu => unicol.def'

! forcing_type defines the way the SCM is forced:
!forcing_type = 0 ==> forcing_les = .true.
!             initial profiles from file prof.inp.001
!             no forcing by LS convergence ; 
!             surface temperature imposed ;
!             radiative cooling may be imposed (iflag_radia=0 in physiq.def)
!forcing_type = 1 ==> forcing_radconv = .true.
!             idem forcing_type = 0, but the imposed radiative cooling 
!             is set to 0 (hence, if iflag_radia=0 in physiq.def, 
!             then there is no radiative cooling at all)
!forcing_type = 2 ==> forcing_toga = .true.
!             initial profiles from TOGA-COARE IFA files 
!             LS convergence and SST imposed from TOGA-COARE IFA files 
!forcing_type = 3 ==> forcing_GCM2SCM = .true.
!             initial profiles from the GCM output
!             LS convergence imposed from the GCM output
!forcing_type = 4 ==> forcing_twpice = .true.
!             initial profiles from TWP-ICE cdf file 
!             LS convergence, omega and SST imposed from TWP-ICE files 
!forcing_type = 5 ==> forcing_rico = .true.
!             initial profiles from RICO files 
!             LS convergence imposed from RICO files 
!forcing_type = 40 ==> forcing_GCSSold = .true.
!             initial profile from GCSS file
!             LS convergence imposed from GCSS file
!forcing_type = 61 ==> forcing_armcu = .true.
!             initial profile from arm_cu file
!             LS convergence imposed from arm_cu file
!
      if (forcing_type .eq.0) THEN
       forcing_les = .true.
      elseif (forcing_type .eq.1) THEN
       forcing_radconv = .true.
      elseif (forcing_type .eq.2) THEN
       forcing_toga    = .true.
      elseif (forcing_type .eq.3) THEN
       forcing_GCM2SCM = .true.
      elseif (forcing_type .eq.4) THEN
       forcing_twpice = .true.
      elseif (forcing_type .eq.5) THEN
       forcing_rico = .true.
      elseif (forcing_type .eq.40) THEN
       forcing_GCSSold = .true.
      elseif (forcing_type .eq.61) THEN
       forcing_armcu = .true.
       IF(llm.NE.19.AND.llm.NE.40) stop 'Erreur nombre de niveaux !!'
      else
       write (*,*) 'ERROR : unknown forcing_type ', forcing_type
       stop 'Forcing_type should be 0,1,2,3 or 40'
      ENDIF
      print*,"forcing type=",forcing_type

! if type_ts_forcing=0, the surface temp of 1D simulation is constant in time
! (specified by tsurf in lmdz1d.def); if type_ts_forcing=1, the surface temperature
! varies in time according to a forcing (e.g. forcing_toga) and is passed to read_tsurf1d.F
! through the common sst_forcing.

        type_ts_forcing = 0
        if (forcing_toga) type_ts_forcing = 1

!---------------------------------------------------------------------
!  Definition of the run
!---------------------------------------------------------------------

      call conf_gcm( 99, .TRUE. , clesphy0 )
c-----------------------------------------------------------------------
c   Choix du calendrier
c   -------------------

c      calend = 'earth_365d'
      if (calend == 'earth_360d') then
        call ioconf_calendar('360d')
        write(*,*)'CALENDRIER CHOISI: Terrestre a 360 jours/an'
      else if (calend == 'earth_365d') then
        call ioconf_calendar('noleap')
        write(*,*)'CALENDRIER CHOISI: Terrestre a 365 jours/an'
      else if (calend == 'earth_366d') then
        call ioconf_calendar('all_leap')
        write(*,*)'CALENDRIER CHOISI: Terrestre bissextile'
      else if (calend == 'gregorian') then
        call ioconf_calendar('gregorian') ! not to be used by normal users
        write(*,*)'CALENDRIER CHOISI: Gregorien'
      else
        write (*,*) 'ERROR : unknown calendar ', calend
        stop 'calend should be 360d,earth_365d,earth_366d,gregorian'
      endif
c-----------------------------------------------------------------------
c
cc Date :
c      La date est supposee donnee sous la forme [annee, numero du jour dans 
c      l annee] ; l heure est donnee dans time_ini, lu dans lmdz1d.def.
c      On appelle ymds2ju pour convertir [annee, jour] en [jour Julien].
c      Le numero du jour est dans "day". L heure est traitee separement.
c      La date complete est dans "daytime" (l'unite est le jour).
      fnday=nday
c Special case for arm_cu which lasts less than one day : 53100s !! (MPL 20111026)
      IF(forcing_type .EQ. 61) fnday=53100./86400.
      annee_ref = anneeref
      mois = 1
      day_ref = dayref
      heure = 0.
      itau_dyn = 0
      itau_phy = 0
      call ymds2ju(annee_ref,mois,day_ref,heure,day)
      day_ini = day
      day_end = day_ini + nday
! Convert the initial date of Toga-Coare to Julian day
      call ymds2ju
     $ (year_ini_toga,mth_ini_toga,day_ini_toga,heure,day_ju_ini_toga)

! Convert the initial date of TWPICE to Julian day
      call ymds2ju
     $ (year_ini_twpi,mth_ini_twpi,day_ini_twpi,heure_ini_twpi
     $ ,day_ju_ini_twpi)

! Convert the initial date of Arm_cu to Julian day
      call ymds2ju
     $ (year_ini_armcu,mth_ini_armcu,day_ini_armcu,heure_ini_armcu
     $ ,day_ju_ini_armcu)

      daytime = day + time_ini/24. ! 1st day and initial time of the simulation 
! Print out the actual date of the beginning of the simulation :
      call ju2ymds(daytime,year_print, month_print,day_print,sec_print)
      print *,' Time of beginning : ',
     $        year_print, month_print, day_print, sec_print

!---------------------------------------------------------------------
! Initialization of dimensions, geometry and initial state
!---------------------------------------------------------------------
      call init_phys_lmdz(1,1,llm,1,(/1/))
      call suphel
      call initcomgeomphy
      call infotrac_init 

      allocate(q(llm,nqtot)) ; q(:,:)=0.
      allocate(dq(llm,nqtot)) 
      allocate(dq_dyn(llm,nqtot)) 
      allocate(d_q_adv(llm,nqtot)) 

c
c   No ozone climatology need be read in this pre-initialization
c          (phys_state_var_init is called again in physiq)
      read_climoz = 0
c
      call phys_state_var_init(read_climoz)

      if (ngrid.ne.klon) then
         print*,'stop in inifis'
         print*,'Probleme de dimensions :'
         print*,'ngrid = ',ngrid
         print*,'klon  = ',klon
         stop
      endif
!!!=====================================================================
!!! Feedback forcing values for Gateaux differentiation (al1)
!!!=====================================================================
!!! Surface Planck forcing bracketing call radiation
!!      surf_Planck = 0.
!!      surf_Conv   = 0.
!!      write(*,*) 'Gateaux-dif Planck,Conv:',surf_Planck,surf_Conv
!!! a mettre dans le lmdz1d.def ou autre
!!
!!
      qsol = qsolinp
      qsurf = fq_sat(tsurf,psurf/100.)
      rlat=xlat
      rlon=xlon
      day1= day_ini
      time=daytime-day
      ts_toga(1)=tsurf ! needed by read_tsurf1d.F
      rho(1)=psurf/(rd*tsurf*(1.+(rv/rd-1.)*qsurf)) 

!
!! mpl et jyg le 22/08/2012 : 
!!  pour que les cas a flux de surface imposes marchent
      IF(.NOT.ok_flux_surf) THEN
       fsens=-wtsurf*rcpd*rho(1)
       flat=-wqsurf*rlvtt*rho(1)
       print *,'Flux: ok_flux wtsurf wqsurf',ok_flux_surf,wtsurf,wqsurf
      ENDIF
!!      ok_flux_surf=.false.
!!      fsens=-wtsurf*rcpd*rho(1)
!!      flat=-wqsurf*rlvtt*rho(1)
!!!!

! Vertical discretization and pressure levels at half and mid levels:

      pa   = 5e4
!!      preff= 1.01325e5
      preff = psurf
      call disvert(pa,preff,ap,bp,dpres,presnivs,nivsigs,nivsig)
      sig_s=presnivs/preff
      plev =ap+bp*psurf
      play = 0.5*(plev(1:llm)+plev(2:llm+1))
ccc      zlay=-rd*300.*log(play/psurf)/rg ! moved after reading profiles

      write(*,*) '***********************'
      do l = 1, llm
       write(*,*) 'l,play(l),presnivs(l): ',l,play(l),presnivs(l)
      enddo
      write(*,*) '***********************'

c
!=====================================================================
! EVENTUALLY, READ FORCING DATA :
!=====================================================================

#include "1D_read_forc_cases.h"

      if (forcing_GCM2SCM) then
        write (*,*) 'forcing_GCM2SCM not yet implemented'
        stop 'in initialization'
      endif ! forcing_GCM2SCM

      print*,'mxcalc=',mxcalc
      print*,'zlay=',zlay(mxcalc)
      print*,'play=',play(mxcalc)

cAl1 pour SST forced, appell depuis ocean_forced_noice
      ts_cur = tsurf ! SST used in read_tsurf1d
!=====================================================================
! Initialisation de la physique : 
!=====================================================================

!  Rq: conf_phys.F90 lit tous les flags de physiq.def; conf_phys appele depuis physiq.F
!
! day_step, iphysiq lus dans gcm.def ci-dessus
! timestep: calcule ci-dessous from rday et day_step
! ngrid=1
! llm: defini dans .../modipsl/modeles/LMDZ4/libf/grid/dimension
! rday: defini dans suphel.F (86400.)
! day_ini: lu dans run.def (dayref)
! rlat,rlon lus dans lmdz1d.def
! airefi,zcufi,zcvfi initialises au debut de ce programme
! rday,ra,rg,rd,rcpd declares dans YOMCST.h et calcules dans suphel.F
      day_step = float(nsplit_phys)*day_step/float(iphysiq)
      write (*,*) 'Time step divided by nsplit_phys (=',nsplit_phys,')'
      timestep =rday/day_step
      dtime_frcg = timestep
!
      zcufi=airefi
      zcvfi=airefi

      call iniphysiq(ngrid,llm,rday,day_ini,timestep,
     .     rlat,rlon,airefi,zcufi,zcvfi,ra,rg,rd,rcpd,1)
      print*,'apres iniphysiq'

! 2 PARAMETRES QUI DEVRAIENT ETRE LUS DANS run.def MAIS NE LE SONT PAS ICI:
      co2_ppm= 330.0
      solaire=1370.0

! Ecriture du startphy avant le premier appel a la physique.
! On le met juste avant pour avoir acces a tous les champs
! NB: les clesphy0 seront remplies dans phyredem d'apres les flags lus dans gcm.def

      if (ok_writedem) then

!--------------------------------------------------------------------------
! pbl_surface_init (called here) and pbl_surface_final (called by phyredem)
! need : qsol fder snow qsurf evap rugos agesno ftsoil
!--------------------------------------------------------------------------

        type_ocean = "force"
        run_off_lic_0(1) = restart_runoff 
        call fonte_neige_init(run_off_lic_0)

        fder=0.
        snsrf(1,:)=0.        ! couverture de neige des sous surface
        qsurfsrf(1,:)=qsurf ! humidite de l'air des sous surface
        evap=0.
        frugs(1,:)=rugos     ! couverture de neige des sous surface
        agesno  = xagesno
        tsoil(:,:,:)=tsurf
        call pbl_surface_init(qsol, fder, snsrf, qsurfsrf,
     &                                    evap, frugs, agesno, tsoil)

!------------------ prepare limit conditions for limit.nc -----------------
!--   Ocean force

        print*,'avant phyredem'
        pctsrf(1,:)=0.
        if (nat_surf.eq.0.) then
          pctsrf(1,is_oce)=1.
          pctsrf(1,is_ter)=0.
        else
          pctsrf(1,is_oce)=0.
          pctsrf(1,is_ter)=1.
        end if

        print*,'nat_surf,pctsrf(1,is_oce),pctsrf(1,is_ter)',nat_surf
     $        ,pctsrf(1,is_oce),pctsrf(1,is_ter)

        zmasq=pctsrf(1,is_ter)+pctsrf(1,is_lic)
        zpic = zpicinp
        ftsol=tsurf
        falb1 = albedo                            
        falb2 = albedo                            
        rugoro=rugos 
        t_ancien(1,:)=temp(:)
        q_ancien(1,:)=q(:,1)
        pbl_tke=1.e-8

        rain_fall=0.
        snow_fall=0.
        solsw=0.
        sollw=0.
        radsol=0.
        rnebcon=0.
        ratqs=0.
        clwcon=0.
        zmea=0.
        zstd=0.
        zsig=0.
        zgam=0.
        zval=0. 
        zthe=0. 
        ema_work1=0.
        ema_work2=0.
 
!------------------------------------------------------------------------
! Make file containing restart for the physics (startphy.nc)
!
! NB: List of the variables to be written by phyredem (via put_field):
! rlon,rlat,zmasq,pctsrf(:,is_ter),pctsrf(:,is_lic),pctsrf(:,is_oce)
! pctsrf(:,is_sic),ftsol(:,nsrf),tsoil(:,isoil,nsrf),qsurf(:,nsrf)
! qsol,falb1(:,nsrf),falb2(:,nsrf),evap(:,nsrf),snow(:,nsrf)
! radsol,solsw,sollw,fder,rain_fall,snow_fall,frugs(:,nsrf)
! agesno(:,nsrf),zmea,zstd,zsig,zgam,zthe,zpic,zval,rugoro
! t_ancien,q_ancien,frugs(:,is_oce),clwcon(:,1),rnebcon(:,1),ratqs(:,1)
! run_off_lic_0,pbl_tke(:,1:klev,nsrf),zmax0,f0,ema_work1,ema_work2
! wake_deltat,wake_deltaq,wake_s,wake_cstar,wake_fip
!------------------------------------------------------------------------
CAl1 =============== restart option ==========================
        if (.not.restart) then
          call phyredem ("startphy.nc")
        else
c (desallocations)
        print*,'callin surf final'
          call pbl_surface_final(qsol, fder, snsrf, qsurfsrf,
     &                                    evap, frugs, agesno, tsoil)
        print*,'after surf final'
          CALL fonte_neige_final(run_off_lic_0)
        endif

        ok_writedem=.false.
        print*,'apres phyredem'

      endif ! ok_writedem
      
!------------------------------------------------------------------------
! Make file containing boundary conditions (limit.nc) **Al1->restartdyn***
! --------------------------------------------------
! NB: List of the variables to be written in limit.nc 
!     (by writelim.F, subroutine of 1DUTILS.h):
!        phy_nat,phy_alb,phy_sst,phy_bil,phy_rug,phy_ice,
!        phy_fter,phy_foce,phy_flic,phy_fsic)
!------------------------------------------------------------------------
      do i=1,yd
        phy_nat(i)  = nat_surf
        phy_alb(i)  = albedo
        phy_sst(i)  = tsurf ! read_tsurf1d will be used instead
        phy_rug(i)  = rugos
        phy_fter(i) = pctsrf(1,is_ter)
        phy_foce(i) = pctsrf(1,is_oce)
        phy_fsic(i) = pctsrf(1,is_sic)
        phy_flic(i) = pctsrf(1,is_lic)
      enddo

C fabrication de limit.nc
      call writelim (1,phy_nat,phy_alb,phy_sst,phy_bil,phy_rug,
     &               phy_ice,phy_fter,phy_foce,phy_flic,phy_fsic)


      call phys_state_var_end
cAl1
      if (restart) then
        print*,'call to restart dyn 1d'
        Call dyn1deta0("start1dyn.nc",
     &              plev,play,phi,phis,presnivs,
     &              u,v,temp,q,omega2)

       print*,'fnday,annee_ref,day_ref,day_ini',
     &     fnday,annee_ref,day_ref,day_ini
c**      call ymds2ju(annee_ref,mois,day_ini,heure,day)
       day = day_ini
       day_end = day_ini + nday
       daytime = day + time_ini/24. ! 1st day and initial time of the simulation 

! Print out the actual date of the beginning of the simulation :
       call ju2ymds(daytime, an, mois, jour, heure)
       print *,' Time of beginning : y m d h',an, mois,jour,heure/3600.

       day = int(daytime)
       time=daytime-day
  
       print*,'****** intialised fields from restart1dyn *******'
       print*,'plev,play,phi,phis,presnivs,u,v,temp,q,omega2'
       print*,'temp(1),q(1,1),u(1),v(1),plev(1),phis :'
       print*,temp(1),q(1,1),u(1),v(1),plev(1),phis
c raz for safety
       do l=1,llm
         dq_dyn(l,1) = 0.
       enddo
      endif
!Al1 ================  end restart =================================
      IF (ecrit_slab_oc.eq.1) then
         open(97,file='div_slab.dat',STATUS='UNKNOWN')
       elseif (ecrit_slab_oc.eq.0) then
         open(97,file='div_slab.dat',STATUS='OLD')
       endif
!=====================================================================
! START OF THE TEMPORAL LOOP :
!=====================================================================
           
      do while(it.le.nint(fnday*day_step))

       if (prt_level.ge.1) then
         print*,'XXXXXXXXXXXXXXXXXXX ITAP,day,time=',
     .                                it,day,time,nint(fnday*day_step)
         print*,'PAS DE TEMPS ',timestep
       endif
!Al1 demande de restartphy.nc
       if (it.eq.nint(fnday*day_step)) lastcall=.True.

!---------------------------------------------------------------------
! Interpolation of forcings in time and onto model levels
!---------------------------------------------------------------------

#include "1D_interp_cases.h"

      if (forcing_GCM2SCM) then
        write (*,*) 'forcing_GCM2SCM not yet implemented'
        stop 'in time loop'
      endif ! forcing_GCM2SCM

!---------------------------------------------------------------------
!  Geopotential :
!---------------------------------------------------------------------

        phi(1)=RD*temp(1)*(plev(1)-play(1))/(.5*(plev(1)+play(1)))
        do l = 1, llm-1
          phi(l+1)=phi(l)+RD*(temp(l)+temp(l+1))*
     .    (play(l)-play(l+1))/(play(l)+play(l+1))
        enddo

!---------------------------------------------------------------------
! Listing output for debug prt_level>=1
!---------------------------------------------------------------------
       if (prt_level>=1) then
         print *,' avant physiq : -------- day time ',day,time
         write(*,*) 'firstcall,lastcall,phis',
     :               firstcall,lastcall,phis
         write(*,'(a10,2a4,4a13)') 'BEFOR1 IT=','it','l',
     :        'presniv','plev','play','phi'
         write(*,'(a10,2i4,4f13.2)') ('BEFOR1 IT= ',it,l,
     :         presnivs(l),plev(l),play(l),phi(l),l=1,llm)
         write(*,'(a11,2a4,a11,6a8)') 'BEFOR2','it','l',
     :         'presniv','u','v','temp','q1','q2','omega2'
         write(*,'(a11,2i4,f11.2,5f8.2,e10.2)') ('BEFOR2 IT= ',it,l,
     :   presnivs(l),u(l),v(l),temp(l),q(l,1),q(l,2),omega2(l),l=1,llm)
       endif

!---------------------------------------------------------------------
!   Call physiq :
!---------------------------------------------------------------------

        call physiq(ngrid,llm,
     :              firstcall,lastcall,
     :              day,time,timestep,
     :              plev,play,phi,phis,presnivs,clesphy0,
     :              u,v,temp,q,omega2,
     :              du_phys,dv_phys,dt_phys,dq,dpsrf,
     :              dudyn,PVteta)
        firstcall=.false.

!---------------------------------------------------------------------
! Listing output for debug prt_level>=1
!---------------------------------------------------------------------
        if (prt_level>=1) then
          write(*,'(a11,2a4,4a13)') 'AFTER1 IT=','it','l',
     :        'presniv','plev','play','phi'
          write(*,'(a11,2i4,4f13.2)') ('AFTER1 it= ',it,l,
     :    presnivs(l),plev(l),play(l),phi(l),l=1,llm)
          write(*,'(a11,2a4,a11,6a8)') 'AFTER2','it','l',
     :         'presniv','u','v','temp','q1','q2','omega2'
          write(*,'(a11,2i4,f11.2,5f8.2,e10.2)') ('AFTER2 it= ',it,l,
     :    presnivs(l),u(l),v(l),temp(l),q(l,1),q(l,2),omega2(l),l=1,llm)
          write(*,'(a11,2a4,a11,5a8)') 'AFTER3','it','l',
     :         'presniv','du_phys','dv_phys','dt_phys','dq1','dq2'
           write(*,'(a11,2i4,f11.2,5f8.2)') ('AFTER3 it= ',it,l,
     :      presnivs(l),86400*du_phys(l),86400*dv_phys(l),
     :       86400*dt_phys(l),86400*dq(l,1),dq(l,2),l=1,llm)
          write(*,*) 'dpsrf',dpsrf
        endif
!---------------------------------------------------------------------
!   Add physical tendencies :
!---------------------------------------------------------------------

       fcoriolis=2.*sin(rpi*xlat/180.)*romega
       if (forcing_radconv) then
         fcoriolis=0.0
         dt_cooling=0.0
         d_th_adv=0.0
         d_q_adv=0.0
       endif

       if (forcing_toga .or. forcing_GCSSold .or. forcing_twpice) then
         fcoriolis=0.0 ; ug=0. ; vg=0.
       endif
         if(forcing_rico) then
          dt_cooling=0.
        endif

      print*, 'fcoriolis ', fcoriolis, xlat

        du_age(1:mxcalc)=
     : fcoriolis*(v(1:mxcalc)-vg(1:mxcalc))
       dv_age(1:mxcalc)=
     : -fcoriolis*(u(1:mxcalc)-ug(1:mxcalc))

        u(1:mxcalc)=u(1:mxcalc) + timestep*(
     :              du_phys(1:mxcalc)
     :             +du_age(1:mxcalc) )            
        v(1:mxcalc)=v(1:mxcalc) + timestep*(
     :	             dv_phys(1:mxcalc)
     :             +dv_age(1:mxcalc) )
        q(1:mxcalc,:)=q(1:mxcalc,:)+timestep*(
     :                dq(1:mxcalc,:)
     :               +d_q_adv(1:mxcalc,:) )

        if (prt_level.ge.1) then
          print *,
     :    'physiq-> temp(1),dt_phys(1),d_th_adv(1),dt_cooling(1) ',
     :              temp(1),dt_phys(1),d_th_adv(1),dt_cooling(1)
           print*,du_phys
           print*, v
           print*, vg
        endif

        temp(1:mxcalc)=temp(1:mxcalc)+timestep*(
     .              dt_phys(1:mxcalc)
     .             +d_th_adv(1:mxcalc)
     .             +dt_cooling(1:mxcalc))  ! Taux de chauffage ou refroid.

        teta=temp*(pzero/play)**rkappa

!---------------------------------------------------------------------
!   Add large-scale tendencies (advection, etc) :
!---------------------------------------------------------------------

ccc nrlmd
ccc        tmpvar=teta
ccc        call advect_vert(llm,omega,timestep,tmpvar,plev)
ccc
ccc        teta(1:mxcalc)=tmpvar(1:mxcalc)
ccc        tmpvar(:)=q(:,1)
ccc        call advect_vert(llm,omega,timestep,tmpvar,plev)
ccc        q(1:mxcalc,1)=tmpvar(1:mxcalc)
ccc        tmpvar(:)=q(:,2)
ccc        call advect_vert(llm,omega,timestep,tmpvar,plev)
ccc        q(1:mxcalc,2)=tmpvar(1:mxcalc)

!---------------------------------------------------------------------
!   Air temperature :
!---------------------------------------------------------------------        
        if (lastcall) then
          print*,'Pas de temps final ',it
          call ju2ymds(daytime, an, mois, jour, heure)
          print*,'a la date : a m j h',an, mois, jour ,heure/3600.
        endif

c  incremente day time
c        print*,'daytime bef',daytime,1./day_step
        daytime = daytime+1./day_step
!Al1dbg
        day = int(daytime+0.1/day_step)
c        time = max(daytime-day,0.0)
cAl1&jyg: correction de bug
ccc        time = real(mod(it,day_step))/day_step
        time = time_ini/24.+real(mod(it,day_step))/day_step
c        print*,'daytime nxt time',daytime,time
        it=it+1

      enddo

!Al1
      if (ecrit_slab_oc.ne.-1) close(97)

!Al1 Call to 1D equivalent of dynredem (an,mois,jour,heure ?)
! -------------------------------------
       call dyn1dredem("restart1dyn.nc",
     :              plev,play,phi,phis,presnivs,
     :              u,v,temp,q,omega2)

        CALL abort_gcm ('lmdz1d   ','The End  ',0)

      end

#include "1DUTILS.h"
#include "1Dconv.h"


