!
! $Id$
!
MODULE dynredem_mod

CONTAINS

  SUBROUTINE dynredem_write_u(ncid,id,var,ll)
  USE dimensions
  USE parallel
  USE mod_hallo
  IMPLICIT NONE
    INTEGER          :: ncid
    CHARACTER(LEN=*) :: id
    REAL             :: var(ijb_u:ije_u,ll)
    REAL,ALLOCATABLE,SAVE  :: var_tmp(:,:)
    REAL,ALLOCATABLE,SAVE  :: var_glo(:)
    INTEGER          :: ll
    INTEGER          :: count(4)
    INTEGER          :: start(4)
    INTEGER          :: l
    INTEGER          :: nvarid
    INTEGER          :: ierr
    INCLUDE 'netcdf.inc'    
    
    count(:)=(/ iip1,jjp1,1,1 /)
    start(:)=(/ 1,1,1,1 /)
    
!$OMP MASTER    
   IF (mpi_rank==0) THEN
     ierr = NF_INQ_VARID(ncid, id, nvarid)
     IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "Variable "//id//" n est pas definie"
       CALL abort
     ENDIF
   ENDIF
!$OMP END MASTER

!$OMP MASTER
    ALLOCATE(var_tmp(ijb_u:ije_u,ll))
    ALLOCATE(var_glo(ip1jmp1))
!$OMP END MASTER
!$OMP BARRIER

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
    DO l=1,ll
      var_tmp(:,l)=var(:,l)
    ENDDO

    DO l=1,ll
      CALL gather_field_u(var_tmp(:,l),var_glo,1)
       IF (mpi_rank==0) THEN
   !$OMP MASTER
        start(3)=l
#ifdef NC_DOUBLE
        ierr = NF_PUT_VARA_DOUBLE (ncid,nvarid,start,count,var_glo)
#else
        ierr = NF_PUT_VARA_REAL (ncid,nvarid,start,count,var_glo)
#endif
   !$OMP END MASTER
       ENDIF
    ENDDO
    
  !$OMP BARRIER
  !$OMP MASTER
    DEALLOCATE(var_tmp)
    DEALLOCATE(var_glo)
  !$OMP END MASTER
  !$OMP BARRIER
  
  END SUBROUTINE dynredem_write_u
      
  SUBROUTINE dynredem_write_v(ncid,id,var,ll)
  USE dimensions
  USE parallel
  USE mod_hallo
  IMPLICIT NONE
    INTEGER          :: ncid
    CHARACTER(LEN=*) :: id
    REAL             :: var(ijb_v:ije_v,ll)
    REAL,ALLOCATABLE,SAVE  :: var_tmp(:,:)
    REAL,ALLOCATABLE,SAVE  :: var_glo(:)
    INTEGER          :: ll
    INTEGER          :: count(4)
    INTEGER          :: start(4)
    INTEGER          :: l
    INTEGER          :: nvarid
    INTEGER          :: ierr
    INCLUDE 'netcdf.inc'    
    
    count(:)=(/ iip1,jjm,1,1 /)
    start(:)=(/ 1,1,1,1 /)
    
!$OMP MASTER    
   IF (mpi_rank==0) THEN
     ierr = NF_INQ_VARID(ncid, id, nvarid)
     IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "Variable "//id//" n est pas definie"
       CALL abort
     ENDIF
   ENDIF
!$OMP END MASTER
 
!$OMP MASTER
    ALLOCATE(var_tmp(ijb_v:ije_v,ll))
    ALLOCATE(var_glo(ip1jm))
!$OMP END MASTER
!$OMP BARRIER

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
    DO l=1,ll
      var_tmp(:,l)=var(:,l)
    ENDDO

    DO l=1,ll
      CALL gather_field_v(var_tmp(:,l),var_glo,1)
       IF (mpi_rank==0) THEN
   !$OMP MASTER
        start(3)=l
#ifdef NC_DOUBLE
        ierr = NF_PUT_VARA_DOUBLE (ncid,nvarid,start,count,var_glo)
#else
        ierr = NF_PUT_VARA_REAL (ncid,nvarid,start,count,var_glo)
#endif
   !$OMP END MASTER
       ENDIF
    ENDDO
    
  !$OMP BARRIER
  !$OMP MASTER
    DEALLOCATE(var_tmp)
    DEALLOCATE(var_glo)
  !$OMP END MASTER
  !$OMP BARRIER
  
  END SUBROUTINE dynredem_write_v

  SUBROUTINE dynredem_read_u(ncid,id,var,ll)
  USE dimensions
  USE parallel
  USE mod_hallo
  IMPLICIT NONE
    INTEGER          :: ncid
    CHARACTER(LEN=*) :: id
    REAL             :: var(ijb_u:ije_u,ll)
    REAL,ALLOCATABLE,SAVE  :: var_tmp(:,:)
    REAL,ALLOCATABLE,SAVE  :: var_glo(:)
    INTEGER          :: ll
    INTEGER          :: count(4)
    INTEGER          :: start(4)
    INTEGER          :: l
    INTEGER          :: nvarid
    INTEGER          :: ierr
    INCLUDE 'netcdf.inc'    
    
    count(:)=(/ iip1,jjp1,1,1 /)
    start(:)=(/ 1,1,1,1 /)
    
!$OMP MASTER    
   IF (mpi_rank==0) THEN
     ierr = NF_INQ_VARID(ncid, id, nvarid)
     IF (ierr .NE. NF_NOERR) THEN
       PRINT*, "Variable "//id//" n est pas definie"
       CALL abort
     ENDIF
   ENDIF
!$OMP END MASTER
 
!$OMP MASTER
    ALLOCATE(var_tmp(ijb_u:ije_u,ll))
    ALLOCATE(var_glo(ip1jmp1))
!$OMP END MASTER
!$OMP BARRIER


    DO l=1,ll
       IF (mpi_rank==0) THEN
   !$OMP MASTER
        start(3)=l
#ifdef NC_DOUBLE
        ierr = NF_GET_VARA_DOUBLE (ncid,nvarid,start,count,var_glo)
#else
        ierr = NF_GET_VARA_REAL (ncid,nvarid,start,count,var_glo)
#endif
   !$OMP END MASTER
       ENDIF
       CALL scatter_field_u(var_glo,var_tmp(:,l),1)
    ENDDO

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
    DO l=1,ll
      var(:,l)=var_tmp(:,l)
    ENDDO
    
  !$OMP BARRIER
  !$OMP MASTER
    DEALLOCATE(var_tmp)
    DEALLOCATE(var_glo)
  !$OMP END MASTER
  !$OMP BARRIER
  
  END SUBROUTINE dynredem_read_u    
  
END MODULE dynredem_mod   
    
    
