! $Id: physiq.F 1565 2011-08-31 12:53:29Z jghattas $
!#define IO_DEBUG

      SUBROUTINE physiq (nlon,nlev, &
     &            debut,lafin,jD_cur, jH_cur,pdtphys, &
     &            paprs,pplay,pphi,pphis,presnivs,clesphy0, &
     &            u,v,t,qx, &
     &            flxmass_w, &
     &            d_u, d_v, d_t, d_qx, d_ps &
     &            , dudyn &
     &            , PVteta)

      USE dimphy
      USE infotrac
      USE comgeomphy

      IMPLICIT none
!======================================================================
! Objet: Moniteur general de la physique du modele
!======================================================================
!
!  Arguments:
!
! nlon----input-I-nombre de points horizontaux
! nlev----input-I-nombre de couches verticales, doit etre egale a klev
! debut---input-L-variable logique indiquant le premier passage
! lafin---input-L-variable logique indiquant le dernier passage
! jD_cur       -R-jour courant a l'appel de la physique (jour julien)
! jH_cur       -R-heure courante a l'appel de la physique (jour julien)
! pdtphys-input-R-pas d'integration pour la physique (seconde)
! paprs---input-R-pression pour chaque inter-couche (en Pa)
! pplay---input-R-pression pour le mileu de chaque couche (en Pa)
! pphi----input-R-geopotentiel de chaque couche (g z) (reference sol)
! pphis---input-R-geopotentiel du sol
! presnivs-input_R_pressions approximat. des milieux couches ( en PA)
! u-------input-R-vitesse dans la direction X (de O a E) en m/s
! v-------input-R-vitesse Y (de S a N) en m/s
! t-------input-R-temperature (K)
! qx------input-R-humidite specifique (kg/kg) et d'autres traceurs
! d_t_dyn-input-R-tendance dynamique pour "t" (K/s)
! d_q_dyn-input-R-tendance dynamique pour "q" (kg/kg/s)
! flxmass_w -input-R- flux de masse verticale
! d_u-----output-R-tendance physique de "u" (m/s/s)
! d_v-----output-R-tendance physique de "v" (m/s/s)
! d_t-----output-R-tendance physique de "t" (K/s)
! d_qx----output-R-tendance physique de "qx" (kg/kg/s)
! d_ps----output-R-tendance physique de la pression au sol
!IM
! PVteta--output-R-vorticite potentielle a des thetas constantes
!======================================================================
#include "dimensions.h"
#include "comcstphy.h"

      integer jjmp1
      parameter (jjmp1=jjm+1-1/jjm)
      integer iip1
      parameter (iip1=iim+1)

      INTEGER ivap          ! indice de traceurs pour vapeur d'eau
      PARAMETER (ivap=1)
      INTEGER iliq          ! indice de traceurs pour eau liquide
      PARAMETER (iliq=2)

!
!
! Variables argument:
!
      INTEGER nlon
      INTEGER nlev
      REAL, intent(in):: jD_cur, jH_cur

      REAL pdtphys
      LOGICAL debut, lafin
      REAL paprs(klon,klev+1)
      REAL pplay(klon,klev)
      REAL pphi(klon,klev)
      REAL pphis(klon)
      REAL presnivs(klev)
      REAL znivsig(klev)
      real pir

      REAL u(klon,klev)
      REAL v(klon,klev)
      REAL t(klon,klev),theta(klon,klev)
      REAL qx(klon,klev,nqtot)
      REAL flxmass_w(klon,klev)
      REAL omega(klon,klev) ! vitesse verticale en Pa/s
      REAL d_u(klon,klev)
      REAL d_v(klon,klev)
      REAL d_t(klon,klev)
      REAL d_qx(klon,klev,nqtot)
      REAL d_ps(klon)
      real da(klon,klev),phi(klon,klev,klev),mp(klon,klev)
!IM definition dynamique o_trac dans phys_output_open
!      type(ctrl_out) :: o_trac(nqtot)
!FH! REAL PVteta(klon,nbteta)
      REAL PVteta(klon,1)
      REAL dudyn(iim+1,jjmp1,klev)

    INTEGER        longcles
    PARAMETER    ( longcles = 20 )

real temp_newton(klon,klev)
integer k
logical, save :: first=.true.

      REAL clesphy0( longcles      )

d_u=0.
d_v=0.
d_t=0.
d_qx=0.
d_ps=0.

     d_u(:,1)=-u(:,1)/86400.
     do k=1,klev
        temp_newton(:,k)=280.+cos(rlatd(:))*40.-pphi(:,k)/rg*6.e-3
        d_t(:,k)=(temp_newton(:,k)-t(:,k))/1.e5
     enddo


      print*,'COUCOU PHYDEV'
      return
      end
