!
! $Id: iniconst.F 1520 2011-05-23 11:37:09Z fairhead $
!
      SUBROUTINE iniconst

      USE control_mod
#ifdef CPP_IOIPSL
      use IOIPSL
#else
! if not using IOIPSL, we still need to use (a local version of) getin
      use ioipsl_getincom
#endif

      IMPLICIT NONE
c
c      P. Le Van
c
c-----------------------------------------------------------------------
c   Declarations:
c   -------------
c
#include "dimensions.h"
#include "paramet.h"
#include "comconst.h"
#include "temps.h"
#include "comvert.h"
#include "iniprint.h"

      character(len=*),parameter :: modname="iniconst"
      character(len=80) :: abort_message
c
c
c
c-----------------------------------------------------------------------
c   dimension des boucles:
c   ----------------------

      im      = iim
      jm      = jjm
      lllm    = llm
      imp1    = iim 
      jmp1    = jjm + 1
      lllmm1  = llm - 1
      lllmp1  = llm + 1

c-----------------------------------------------------------------------

      dtphys  = iphysiq * dtvr
      unsim   = 1./iim
      pi      = 2.*ASIN( 1. )

c-----------------------------------------------------------------------
c

      r       = cpp * kappa

      write(lunout,*) trim(modname),': R  CP  Kappa ',r,cpp,kappa
c
c-----------------------------------------------------------------------

! vertical discretization: default behavior depends on planet_type flag
      if (planet_type=="earth") then
        disvert_type=1
      else
        disvert_type=2
      endif
      ! but user can also specify using one or the other in run.def:
      call getin('disvert_type',disvert_type)
      write(lunout,*) trim(modname),': disvert_type=',disvert_type
      
      if (disvert_type==1) then
       ! standard case for Earth (automatic generation of levels)
       call disvert(pa,preff,ap,bp,dpres,presnivs,nivsigs,nivsig,
     &              scaleheight)
      else if (disvert_type==2) then
        ! standard case for planets (levels generated using z2sig.def file)
        call disvert_noterre
      else
        write(abort_message,*) "Wrong value for disvert_type: ",
     &                        disvert_type
        call abort_gcm(modname,abort_message,0)
      endif

      END
