!
! $Id: abort_gcm.F 1492 2011-03-08 08:10:25Z fairhead $
!
c
c
      SUBROUTINE abort_gcm(modname, message, ierr)
     
#ifdef CPP_IOIPSL
      USE IOIPSL
#else
! if not using IOIPSL, we still need to use (a local version of) getin_dump
      USE ioipsl_getincom
#endif
      USE parallel
#include "iniprint.h"
 
C
C Stops the simulation cleanly, closing files and printing various
C comments
C
C  Input: modname = name of calling program
C         message = stuff to print
C         ierr    = severity of situation ( = 0 normal )

      character(len=*) modname
      integer ierr
      character(len=*) message

      write(lunout,*) 'in abort_gcm'
#ifdef CPP_IOIPSL
c$OMP MASTER
      call histclo
      call restclo
      if (MPI_rank .eq. 0) then
         call getin_dump
      endif
c$OMP END MASTER
#endif
c     call histclo(2)
c     call histclo(3)
c     call histclo(4)
c     call histclo(5)
      write(lunout,*) 'Stopping in ', modname
      write(lunout,*) 'Reason = ',message
      if (ierr .eq. 0) then
        write(lunout,*) 'Everything is cool'
      else
        write(lunout,*) 'Houston, we have a problem ', ierr
        stop 1
      endif
      END
