!
! $Id: ugeostr.F 1403 2010-07-01 09:02:53Z fairhead $
!
      subroutine ugeostr(phi,ucov)


c  Calcul du vent covariant geostrophique a partir du champs de
c  geopotentiel en supposant que le vent au sol est nul.

      implicit none

#include "dimensions.h"
#include "paramet.h"
#include "comconst.h"
#include "comgeom2.h"

      real ucov(iip1,jjp1,llm),phi(iip1,jjp1,llm)
      real um(jjm,llm),fact,u(iip1,jjm,llm)
      integer i,j,l

      real zlat

      um(:,:)=0 ! initialize um()

      DO j=1,jjm

         if (abs(sin(rlatv(j))).lt.1.e-4) then
             zlat=1.e-4
         else
             zlat=rlatv(j)
         endif
         fact=cos(zlat)
         fact=fact*fact
         fact=fact*fact
         fact=fact*fact
         fact=(1.-fact)/
     s    (2.*omeg*sin(zlat)*(rlatu(j+1)-rlatu(j)))
         fact=-fact/rad
         DO l=1,llm
            DO i=1,iim
               u(i,j,l)=fact*(phi(i,j+1,l)-phi(i,j,l))
               um(j,l)=um(j,l)+u(i,j,l)/REAL(iim)
            ENDDO
         ENDDO
      ENDDO
      call dump2d(jjm,llm,um,'Vent-u geostrophique')

c
c-----------------------------------------------------------------------
c   calcul des champ de vent:
c   -------------------------

      DO 301 l=1,llm
         DO 302 i=1,iip1
            ucov(i,1,l)=0.
            ucov(i,jjp1,l)=0.
302      CONTINUE
         DO 304 j=2,jjm
            DO 305 i=1,iim
               ucov(i,j,l) = 0.5*(u(i,j,l)+u(i,j-1,l))*cu(i,j)
305         CONTINUE
            ucov(iip1,j,l)=ucov(1,j,l)
304      CONTINUE
301   CONTINUE

      print*,301

      return
      end
