! $Id$
module nf95_put_var_m

  implicit none

  interface nf95_put_var
     module procedure nf95_put_var_1D_FourByteReal, &
          nf95_put_var_2D_FourByteReal, nf95_put_var_3D_FourByteReal, &
          nf95_put_var_4D_FourByteReal
!!$     module procedure nf95_put_var_1D_FourByteReal, &
!!$          nf95_put_var_2D_FourByteReal, nf95_put_var_3D_FourByteReal, &
!!$          nf95_put_var_4D_FourByteReal, nf90_put_var_1D_EightByteReal, &
!!$          nf90_put_var_3D_EightByteReal
  end interface

  private
  public nf95_put_var

contains

  subroutine nf95_put_var_1D_FourByteReal(ncid, varid, values, start, count, &
       stride, map, ncerr)

    use typesizes, only: FourByteReal
    use netcdf, only: nf90_put_var
    use handle_err_m, only: handle_err

    integer,                         intent(in) :: ncid, varid
    real(kind = FourByteReal), intent(in) :: values(:)
    integer, dimension(:), optional, intent(in) :: start, count, stride, map
    integer, intent(out), optional:: ncerr

    ! Variable local to the procedure:
    integer ncerr_not_opt

    !-------------------

    ncerr_not_opt = nf90_put_var(ncid, varid, values, start, count, stride, &
         map)
    if (present(ncerr)) then
       ncerr = ncerr_not_opt
    else
       call handle_err("nf95_put_var_1D_FourByteReal", ncerr_not_opt, ncid, &
            varid)
    end if

  end subroutine nf95_put_var_1D_FourByteReal

  !***********************

  subroutine nf95_put_var_2D_FourByteReal(ncid, varid, values, start, count, &
       stride, map, ncerr)

    use typesizes, only: FourByteReal
    use netcdf, only: nf90_put_var
    use handle_err_m, only: handle_err

    integer,                         intent( in) :: ncid, varid
    real (kind = FourByteReal), intent( in) :: values(:, :)
    integer, dimension(:), optional, intent( in) :: start, count, stride, map
    integer, intent(out), optional:: ncerr

    ! Variable local to the procedure:
    integer ncerr_not_opt

    !-------------------

    ncerr_not_opt = nf90_put_var(ncid, varid, values, start, count, stride, &
         map)
    if (present(ncerr)) then
       ncerr = ncerr_not_opt
    else
       call handle_err("nf95_put_var_2D_FourByteReal", ncerr_not_opt, ncid, &
            varid)
    end if

  end subroutine nf95_put_var_2D_FourByteReal

  !***********************

  subroutine nf95_put_var_3D_FourByteReal(ncid, varid, values, start, count, &
       stride, map, ncerr)

    use typesizes, only: FourByteReal
    use netcdf, only: nf90_put_var
    use handle_err_m, only: handle_err

    integer,                         intent( in) :: ncid, varid
    real (kind = FourByteReal), intent( in) :: values(:, :, :)
    integer, dimension(:), optional, intent( in) :: start, count, stride, map
    integer, intent(out), optional:: ncerr

    ! Variable local to the procedure:
    integer ncerr_not_opt

    !-------------------

    ncerr_not_opt = nf90_put_var(ncid, varid, values, start, count, stride, &
         map)
    if (present(ncerr)) then
       ncerr = ncerr_not_opt
    else
       call handle_err("nf95_put_var_3D_FourByteReal", ncerr_not_opt, ncid, &
            varid)
    end if

  end subroutine nf95_put_var_3D_FourByteReal

  !***********************

  subroutine nf95_put_var_4D_FourByteReal(ncid, varid, values, start, count, &
       stride, map, ncerr)

    use typesizes, only: FourByteReal
    use netcdf, only: nf90_put_var
    use handle_err_m, only: handle_err

    integer,                         intent( in) :: ncid, varid
    real (kind = FourByteReal), intent( in) :: values(:, :, :, :)
    integer, dimension(:), optional, intent( in) :: start, count, stride, map
    integer, intent(out), optional:: ncerr

    ! Variable local to the procedure:
    integer ncerr_not_opt

    !-------------------

    ncerr_not_opt = nf90_put_var(ncid, varid, values, start, count, stride, &
         map)
    if (present(ncerr)) then
       ncerr = ncerr_not_opt
    else
       call handle_err("nf95_put_var_4D_FourByteReal", ncerr_not_opt, ncid, &
            varid)
    end if

  end subroutine nf95_put_var_4D_FourByteReal

  !***********************

!!$  subroutine nf90_put_var_1D_EightByteReal(ncid, varid, values, start, count, &
!!$       stride, map, ncerr)
!!$
!!$    use typesizes, only: eightByteReal
!!$    use netcdf, only: nf90_put_var
!!$    use handle_err_m, only: handle_err
!!$
!!$    integer,                         intent( in) :: ncid, varid
!!$    real (kind = EightByteReal),     intent( in) :: values(:)
!!$    integer, dimension(:), optional, intent( in) :: start, count, stride, map
!!$    integer, intent(out), optional:: ncerr
!!$
!!$    ! Variable local to the procedure:
!!$    integer ncerr_not_opt
!!$
!!$    !-------------------
!!$
!!$    ncerr_not_opt = nf90_put_var(ncid, varid, values, start, count, stride, &
!!$         map)
!!$    if (present(ncerr)) then
!!$       ncerr = ncerr_not_opt
!!$    else
!!$       call handle_err("nf95_put_var_1D_eightByteReal", ncerr_not_opt, ncid, &
!!$            varid)
!!$    end if
!!$
!!$  end subroutine nf90_put_var_1D_EightByteReal
!!$
!!$  !***********************
!!$
!!$  subroutine nf90_put_var_3D_EightByteReal(ncid, varid, values, start, count, &
!!$       stride, map, ncerr)
!!$
!!$    use typesizes, only: eightByteReal
!!$    use netcdf, only: nf90_put_var
!!$    use handle_err_m, only: handle_err
!!$
!!$    integer,                         intent( in) :: ncid, varid
!!$    real (kind = EightByteReal),     intent( in) :: values(:, :, :)
!!$    integer, dimension(:), optional, intent( in) :: start, count, stride, map
!!$    integer, intent(out), optional:: ncerr
!!$
!!$    ! Variable local to the procedure:
!!$    integer ncerr_not_opt
!!$
!!$    !-------------------
!!$
!!$    ncerr_not_opt = nf90_put_var(ncid, varid, values, start, count, stride, &
!!$         map)
!!$    if (present(ncerr)) then
!!$       ncerr = ncerr_not_opt
!!$    else
!!$       call handle_err("nf95_put_var_3D_eightByteReal", ncerr_not_opt, ncid, &
!!$            varid)
!!$    end if
!!$
!!$  end subroutine nf90_put_var_3D_EightByteReal

end module nf95_put_var_m
