! $Id$
module nf95_def_var_m

  implicit none

  interface nf95_def_var
    module procedure nf95_def_var_oneDim, nf95_def_var_ManyDims
  end interface

  private
  public nf95_def_var

contains

  subroutine nf95_def_var_oneDim(ncid, name, xtype, dimids, varid, ncerr)

    use netcdf, only: nf90_def_var
    use handle_err_m, only: handle_err

    integer,               intent( in) :: ncid
    character (len = *),   intent( in) :: name
    integer,               intent( in) :: xtype
    integer,               intent( in) :: dimids
    integer,               intent(out) :: varid
    integer, intent(out), optional:: ncerr

    ! Variable local to the procedure:
    integer ncerr_not_opt

    !-------------------

    ncerr_not_opt = nf90_def_var(ncid, name, xtype, dimids, varid)
    if (present(ncerr)) then
       ncerr = ncerr_not_opt
    else
       call handle_err("nf95_def_var_oneDim " // name, ncerr_not_opt, ncid)
    end if

  end subroutine nf95_def_var_oneDim

  !***********************

  subroutine nf95_def_var_ManyDims(ncid, name, xtype, dimids, varid, ncerr)

    use netcdf, only: nf90_def_var
    use handle_err_m, only: handle_err

    integer,               intent( in) :: ncid
    character (len = *),   intent( in) :: name
    integer,               intent( in) :: xtype
    integer, dimension(:), intent( in) :: dimids
    integer,               intent(out) :: varid
    integer, intent(out), optional:: ncerr

    ! Variable local to the procedure:
    integer ncerr_not_opt

    !-------------------

    ncerr_not_opt = nf90_def_var(ncid, name, xtype, dimids, varid)
    if (present(ncerr)) then
       ncerr = ncerr_not_opt
    else
       call handle_err("nf95_def_var_ManyDims " // name, ncerr_not_opt, ncid)
    end if

  end subroutine nf95_def_var_ManyDims

end module nf95_def_var_m
