! $Id$
module netcdf95

  ! Author: Lionel GUEZ

  ! Three criticisms may be made about the Fortran 90 NetCDF interface:

  ! -- NetCDF procedures are usually functions with side effects.
  ! First, they have "intent(out)" arguments.
  ! Furthermore, there is obviously data transfer inside the procedures.
  ! Any data transfer inside a function is considered as a side effect.

  ! -- The caller of a NetCDF procedure usually has to handle the error
  ! status. NetCDF procedures would be much friendlier if they behaved
  ! like the Fortran input/output statements. That is, the error status
  ! should be an optional output argument.
  ! If the caller does not request the error status and there is an
  ! error then the NetCDF procedure should produce an error message
  ! and stop the program.

  ! -- Some procedures use array arguments with assumed size.
  ! It would be better to use the pointer attribute.

  ! This module produces a NetCDF interface that answers those three
  ! criticisms for some (not all) procedures.

  ! This module replaces some of the official NetCDF procedures.
  ! This module also provides the procedures "handle_err" and "nf95_gw_var".

  ! This module provides only a partial replacement for some generic
  ! procedures such as "nf90_def_var".

  use nf95_def_var_m
  use nf95_put_var_m
  use nf95_gw_var_m
  use nf95_put_att_m
  use simple
  use handle_err_m

end module netcdf95
